/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDBundleInformationCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkBundleName(fileName, absolutePath, content);
            String bundleVersion = BNDSourceUtil.getDefinitionValue(content, "Bundle-Version");
            if (bundleVersion == null) {
                this.addMessage(fileName, "Missing Bundle-Version", "bnd_bundle_information.markdown");
            }
        }
        return content;
    }

    private void _checkBundleName(String fileName, String absolutePath, String content) {
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        String bundleName = BNDSourceUtil.getDefinitionValue(content, "Bundle-Name");
        if (bundleName != null) {
            String strippedBundleName = StringUtil.removeChars(bundleName, '-', ' ');
            String expectedBundleName = "liferay-" + moduleName;
            expectedBundleName = expectedBundleName.replaceAll("(?<!portal)-impl($|-)", "implementation");
            expectedBundleName = expectedBundleName.replaceAll("(?<!portal)-util($|-)", "utilities");
            if (!StringUtil.equalsIgnoreCase(strippedBundleName, expectedBundleName = StringUtil.removeChars(expectedBundleName, '-'))) {
                this.addMessage(fileName, "Incorrect Bundle-Name '" + bundleName + "'", "bnd_bundle_information.markdown");
            }
        } else {
            this.addMessage(fileName, "Missing Bundle-Name", "bnd_bundle_information.markdown");
        }
        if (moduleName.endsWith("-import") || moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName != null) {
            moduleName = StringUtil.replace(moduleName, '-', '.');
            String expectedBundleSymbolicName = "com.liferay." + moduleName;
            if (!bundleSymbolicName.equals(expectedBundleSymbolicName)) {
                this.addMessage(fileName, "Incorrect Bundle-SymbolicName '" + bundleSymbolicName + "'", "bnd_bundle_information.markdown");
            }
        } else {
            this.addMessage(fileName, "Missing Bundle-SymbolicName", "bnd_bundle_information.markdown");
        }
    }
}

