/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class FilterStringWhitespaceCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_WHITESPACE = "whitespace.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "ServiceTrackerFactory", "open");
        this._checkMethod(detailAST, "WaiterUtil", "waitForFilter");
    }

    private void _checkFilterStringAssign(DetailAST assignDetailAST, String filterStringVariableName) {
        DetailAST nameDetailAST = null;
        DetailAST parentDetailAST = assignDetailAST.getParent();
        nameDetailAST = parentDetailAST.getType() == 10 ? parentDetailAST.findFirstToken(58) : assignDetailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        if (!name.equals(filterStringVariableName)) {
            return;
        }
        List<DetailAST> literalStringDetailASTList = DetailASTUtil.getAllChildTokens(assignDetailAST, true, 139);
        for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
            String literalStringValue = literalStringDetailAST.getText();
            if (!literalStringValue.contains(" = ")) continue;
            this.log(nameDetailAST, _MSG_INCORRECT_WHITESPACE, new Object[]{name});
            return;
        }
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String filterStringVariableName = this._getFilterStringVariableName(methodCallDetailAST);
            if (filterStringVariableName == null) continue;
            List<DetailAST> assignDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 80);
            for (DetailAST assignDetailAST : assignDetailASTList) {
                this._checkFilterStringAssign(assignDetailAST, filterStringVariableName);
            }
        }
    }

    private String _getFilterStringVariableName(DetailAST methodCallDetailAST) {
        DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
        if (exprDetailASTList.size() < 2) {
            return null;
        }
        DetailAST secondParameterDetailAST = exprDetailASTList.get(1);
        DetailAST firstChildDetailAST = secondParameterDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            return null;
        }
        return firstChildDetailAST.getText();
    }
}

