/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLSourceUtil {
    public static List<String> getDefinitions(String content, String indent) {
        ArrayList<String> definitions = new ArrayList<String>();
        Pattern pattern = Pattern.compile(StringBundler.concat("^", indent, "[a-z].*:.*(\n|\\Z)((", indent, "[^a-z\n].*)?(\n|\\Z))*"), 8);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            definitions.add(matcher.group());
        }
        return definitions;
    }

    public static String getNestedDefinitionIndent(String definition) {
        String[] lines = StringUtil.splitLines(definition);
        if (lines.length <= 1) {
            return "";
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String indent = line.replaceAll("^(\\s+).+", "$1");
            if (indent.equals(line)) continue;
            return indent;
        }
        return "";
    }
}

