/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;

public class TestClassCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ABSTRACT_TEST_CASE_CLASS = "test.case.class.incorrect.abstract";
    private static final String _MSG_INCORRECT_ABSTRACT_TEST_CLASS = "test.class.incorrect.abstract";
    private static final String _MSG_INVALID_BASE_CLASS_NAME = "test.base.class.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (!fileName.contains("/test/") && !fileName.contains("/testIntegration/")) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        if (!name.matches(".*Test(Case)?")) {
            return;
        }
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (name.endsWith("TestCase")) {
            if (!modifiersAST.branchContains(40)) {
                this.log(detailAST, _MSG_INCORRECT_ABSTRACT_TEST_CASE_CLASS, new Object[]{name.substring(0, name.length() - 4)});
            } else if (name.contains("Base") && !name.startsWith("Base")) {
                this.log(detailAST, _MSG_INVALID_BASE_CLASS_NAME, new Object[]{name});
            }
        } else if (modifiersAST.branchContains(40)) {
            this.log(detailAST, _MSG_INCORRECT_ABSTRACT_TEST_CLASS, new Object[]{name});
        }
    }
}

