/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticBlockCheck
extends BaseCheck {
    private static final String _MSG_UNNEEDED_STATIC_BLOCK = "static.block.unneeded";
    private String[] _immutableFieldTypes = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{12};
    }

    public void setImmutableFieldTypes(String immutableFieldTypes) {
        this._immutableFieldTypes = ArrayUtil.append(this._immutableFieldTypes, StringUtil.split(immutableFieldTypes));
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> classObjectNames = this._getClassObjectNames(detailAST);
        if (classObjectNames.isEmpty()) {
            return;
        }
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        if (methodCallASTList.isEmpty()) {
            return;
        }
        Map<String, List<DetailAST>> identASTMap = this._getIdentASTMap(detailAST);
        Map<String, DetailAST[]> variableDefMap = this._getVariableDefMap(detailAST, identASTMap);
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkMethodCall(methodCallAST, classObjectNames, identASTMap, variableDefMap);
        }
    }

    private void _checkMethodCall(DetailAST methodCallAST, List<String> classObjectNames, Map<String, List<DetailAST>> identASTMap, Map<String, DetailAST[]> variableDefMap) {
        String variableName = DetailASTUtil.getVariableName(methodCallAST);
        if (!classObjectNames.contains(variableName) || variableName.equals("_log")) {
            return;
        }
        DetailAST topLevelDetailAST = this._getTopLevelDetailAST(methodCallAST);
        int statementEndLineNumber = DetailASTUtil.getEndLineNumber(topLevelDetailAST);
        List<DetailAST> variableASTList = identASTMap.get(variableName);
        DetailAST firstUseVariableAST = variableASTList.get(0);
        topLevelDetailAST = this._getTopLevelDetailAST(firstUseVariableAST);
        int statementStartLineNumber = DetailASTUtil.getStartLineNumber(topLevelDetailAST);
        if (!this._isRequiredMethodCall(variableName, classObjectNames, identASTMap, variableDefMap, statementStartLineNumber, statementEndLineNumber)) {
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotAST);
            this.log(methodCallAST, _MSG_UNNEEDED_STATIC_BLOCK, new Object[]{fullIdent.getText()});
        }
    }

    private List<String> _getClassObjectNames(DetailAST staticInitAST) {
        ArrayList<String> staticObjectNames = new ArrayList<String>();
        DetailAST previousSiblingAST = staticInitAST.getPreviousSibling();
        while (previousSiblingAST != null) {
            DetailAST modifiersAST = previousSiblingAST.findFirstToken(5);
            if (modifiersAST == null) {
                previousSiblingAST = previousSiblingAST.getPreviousSibling();
                continue;
            }
            DetailAST nameAST = previousSiblingAST.findFirstToken(58);
            String name = nameAST.getText();
            if (previousSiblingAST.getType() != 10) {
                staticObjectNames.add(name);
            } else {
                String typeName = DetailASTUtil.getTypeName(previousSiblingAST, true);
                if (!ArrayUtil.contains(this._immutableFieldTypes, typeName)) {
                    staticObjectNames.add(name);
                }
            }
            previousSiblingAST = previousSiblingAST.getPreviousSibling();
        }
        return staticObjectNames;
    }

    private Map<String, List<DetailAST>> _getIdentASTMap(DetailAST staticInitAST) {
        HashMap<String, List<DetailAST>> identASTMap = new HashMap<String, List<DetailAST>>();
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(staticInitAST, true, 58);
        for (DetailAST identAST : identASTList) {
            ArrayList<DetailAST> list = (ArrayList<DetailAST>)identASTMap.get(identAST.getText());
            if (list == null) {
                list = new ArrayList<DetailAST>();
            }
            list.add(identAST);
            identASTMap.put(identAST.getText(), list);
        }
        return identASTMap;
    }

    private DetailAST _getTopLevelDetailAST(DetailAST detailAST) {
        DetailAST topLevelDetailAST = null;
        DetailAST parentAST = detailAST;
        DetailAST grandParentAST;
        while ((grandParentAST = parentAST.getParent()).getType() != 12) {
            if (grandParentAST.getType() == 7) {
                topLevelDetailAST = parentAST;
            }
            parentAST = grandParentAST;
        }
        return topLevelDetailAST;
    }

    private Map<String, DetailAST[]> _getVariableDefMap(DetailAST staticInitAST, Map<String, List<DetailAST>> identASTMap) {
        HashMap<String, DetailAST[]> variableDefMap = new HashMap<String, DetailAST[]>();
        List<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(staticInitAST, true, 10);
        for (DetailAST variableDefAST : variableDefASTList) {
            DetailAST nameAST = variableDefAST.findFirstToken(58);
            String name = nameAST.getText();
            List<DetailAST> identASTList = identASTMap.get(name);
            DetailAST firstIdentAST = identASTList.get(0);
            DetailAST lastIdentAST = identASTList.get(identASTList.size() - 1);
            variableDefMap.put(name, new DetailAST[]{firstIdentAST, lastIdentAST});
        }
        return variableDefMap;
    }

    private boolean _isRequiredMethodCall(String variableName, List<String> classObjectNames, Map<String, List<DetailAST>> identASTMap, Map<String, DetailAST[]> variableDefMap, int start, int end) {
        for (Map.Entry<String, List<DetailAST>> entry : identASTMap.entrySet()) {
            String name = entry.getKey();
            if (name.equals(variableName)) {
                for (DetailAST detailAST : entry.getValue()) {
                    DetailAST literalNewAST;
                    if (detailAST.getLineNo() > end) break;
                    DetailAST parentAST = detailAST.getParent();
                    if (parentAST.getType() == 59 || parentAST.getType() == 80 && (literalNewAST = parentAST.findFirstToken(136)) != null) continue;
                    return true;
                }
                continue;
            }
            for (DetailAST detailAST : entry.getValue()) {
                if (detailAST.getLineNo() < start || detailAST.getLineNo() > end) continue;
                if (classObjectNames.contains(name)) {
                    return true;
                }
                DetailAST[] firstAndLastUsedDetailASTArray = variableDefMap.get(name);
                if (firstAndLastUsedDetailASTArray == null) continue;
                DetailAST lastUsedDetailAST = firstAndLastUsedDetailASTArray[1];
                if (lastUsedDetailAST.getLineNo() > end) {
                    return true;
                }
                DetailAST firstUsedDetailAST = firstAndLastUsedDetailASTArray[0];
                if (firstUsedDetailAST.getLineNo() >= start) continue;
                DetailAST topLevelDetailAST = this._getTopLevelDetailAST(firstUsedDetailAST);
                int statementStartLineNumber = DetailASTUtil.getStartLineNumber(topLevelDetailAST);
                return this._isRequiredMethodCall(variableName, classObjectNames, identASTMap, variableDefMap, statementStartLineNumber, end);
            }
        }
        return false;
    }
}

