/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL = "empty.line.missing.after.method.call";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_DEFINITION = "empty.line.missing.before.variable.definition";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";

    public int[] getDefaultTokens() {
        return new int[]{80, 27, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkMissingEmptyLineAfterMethodCall(detailAST);
            return;
        }
        if (detailAST.getType() == 10) {
            this._checkMissingEmptyLineBeforeVariableDef(detailAST);
            return;
        }
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() == 59) {
            return;
        }
        String variableName = this._getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        this._checkMissingEmptyLineAfterReferencingVariable(parentAST, variableName, DetailASTUtil.getEndLineNumber(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentAST, variableName, DetailASTUtil.getEndLineNumber(detailAST));
    }

    private void _checkMissingEmptyLineAfterMethodCall(DetailAST detailAST) {
        DetailAST firstChildAST;
        int nextExpressionStartLineNumber;
        String variableName = DetailASTUtil.getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingAST = parentAST.getNextSibling();
        if (nextSiblingAST == null || nextSiblingAST.getType() != 45) {
            return;
        }
        if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null) {
            return;
        }
        int endLineNumber = DetailASTUtil.getEndLineNumber(detailAST);
        if (endLineNumber + 1 != (nextExpressionStartLineNumber = DetailASTUtil.getStartLineNumber(nextSiblingAST))) {
            return;
        }
        if (nextSiblingAST.getType() == 28 && (firstChildAST = nextSiblingAST.getFirstChild()).getType() == 27 && variableName.equals(DetailASTUtil.getVariableName(firstChildAST))) {
            return;
        }
        if (this._containsVariableName(nextSiblingAST, variableName)) {
            this.log(endLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL, new Object[]{endLineNumber});
        }
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String variableName, int endLineNumber) {
        String lastAssignedVariableName = null;
        DetailAST previousAST = null;
        boolean referenced = false;
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        while (nextSiblingAST != null && nextSiblingAST.getType() == 45) {
            if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null || nextSiblingAST.getType() != 28 && nextSiblingAST.getType() != 10) {
                return;
            }
            if (!this._containsVariableName(nextSiblingAST, variableName)) {
                if (!referenced) {
                    return;
                }
                int nextExpressionStartLineNumber = DetailASTUtil.getStartLineNumber(nextSiblingAST);
                if (endLineNumber + 1 != nextExpressionStartLineNumber) {
                    return;
                }
                if (this._containsVariableName(previousAST, lastAssignedVariableName) && this._containsVariableName(nextSiblingAST, lastAssignedVariableName)) {
                    return;
                }
                this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{nextExpressionStartLineNumber, variableName});
                return;
            }
            List<DetailAST> assignASTList = DetailASTUtil.getAllChildTokens(nextSiblingAST, false, 80);
            if (assignASTList.size() == 1) {
                lastAssignedVariableName = this._getVariableName(assignASTList.get(0));
            }
            referenced = true;
            endLineNumber = DetailASTUtil.getEndLineNumber(nextSiblingAST);
            previousAST = nextSiblingAST;
            nextSiblingAST = nextSiblingAST.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineBeforeVariableDef(DetailAST variableDefAST) {
        DetailAST nextSiblingAST = variableDefAST.getNextSibling();
        if (nextSiblingAST == null || nextSiblingAST.getType() != 45) {
            return;
        }
        if (this._hasPrecedingVariableDef(variableDefAST)) {
            return;
        }
        List<DetailAST> adjacentVariableDefASTList = this._getAdjacentVariableDefASTList(variableDefAST);
        if (adjacentVariableDefASTList.size() <= 1) {
            return;
        }
        DetailAST lastVariableDefAST = adjacentVariableDefASTList.get(adjacentVariableDefASTList.size() - 1);
        List<DetailAST> identASTList = this._getFollowingStatementsIdentASTList(lastVariableDefAST);
        if (this._containsVariableName(identASTList, variableDefAST)) {
            return;
        }
        DetailAST firstReferencedVariableAST = null;
        for (int i = 1; i < adjacentVariableDefASTList.size(); ++i) {
            DetailAST curVariableDefAST = adjacentVariableDefASTList.get(i);
            if (this._containsVariableName(identASTList, curVariableDefAST)) {
                if (firstReferencedVariableAST != null) continue;
                firstReferencedVariableAST = curVariableDefAST;
                continue;
            }
            if (firstReferencedVariableAST == null) continue;
            return;
        }
        if (firstReferencedVariableAST != null) {
            DetailAST nameAST = firstReferencedVariableAST.findFirstToken(58);
            this.log(firstReferencedVariableAST, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_DEFINITION, new Object[]{nameAST.getText()});
        }
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLineNumber) {
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        if (nextSiblingAST == null || nextSiblingAST.getType() != 45) {
            return;
        }
        if ((nextSiblingAST = nextSiblingAST.getNextSibling()) == null) {
            return;
        }
        int nextExpressionStartLineNumber = DetailASTUtil.getStartLineNumber(nextSiblingAST);
        if (endLineNumber + 1 != nextExpressionStartLineNumber) {
            return;
        }
        if (this._isExpressionAssignsVariable(nextSiblingAST, name)) {
            return;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSiblingAST, true, 58);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(name)) continue;
            this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private boolean _containsVariableName(DetailAST detailAST, String variableName) {
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        return this._containsVariableName(identASTList, variableName);
    }

    private boolean _containsVariableName(List<DetailAST> identASTList, DetailAST variableDefAST) {
        DetailAST nameAST = variableDefAST.findFirstToken(58);
        if (nameAST == null) {
            return false;
        }
        return this._containsVariableName(identASTList, nameAST.getText());
    }

    private boolean _containsVariableName(List<DetailAST> identASTList, String variableName) {
        if (variableName == null) {
            return false;
        }
        for (DetailAST identAST : identASTList) {
            if (!variableName.equals(identAST.getText())) continue;
            return true;
        }
        return false;
    }

    private List<DetailAST> _getAdjacentVariableDefASTList(DetailAST variableDefAST) {
        ArrayList<DetailAST> variableDefASTList = new ArrayList<DetailAST>();
        variableDefASTList.add(variableDefAST);
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(variableDefAST, false);
        while (followingStatementDetailAST != null && followingStatementDetailAST.getType() == 10) {
            variableDefASTList.add(followingStatementDetailAST);
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return variableDefASTList;
    }

    private DetailAST _getFollowingStatementDetailAST(DetailAST detailAST, boolean allowDividingEmptyLine) {
        int nextStartLineNumber;
        int endLineNumber = DetailASTUtil.getEndLineNumber(detailAST);
        DetailAST nextSiblingAST = detailAST.getNextSibling();
        while (true) {
            if (nextSiblingAST == null) {
                return null;
            }
            nextStartLineNumber = DetailASTUtil.getStartLineNumber(nextSiblingAST);
            if (nextStartLineNumber > endLineNumber) break;
            nextSiblingAST = nextSiblingAST.getNextSibling();
        }
        if (allowDividingEmptyLine || nextStartLineNumber == endLineNumber + 1) {
            return nextSiblingAST;
        }
        return null;
    }

    private List<DetailAST> _getFollowingStatementsIdentASTList(DetailAST variableDefAST) {
        ArrayList<DetailAST> identASTList = new ArrayList<DetailAST>();
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(variableDefAST, true);
        while (followingStatementDetailAST != null) {
            identASTList.addAll(DetailASTUtil.getAllChildTokens(followingStatementDetailAST, true, 58));
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return identASTList;
    }

    private String _getVariableName(DetailAST assignAST) {
        DetailAST nameAST = null;
        DetailAST parentAST = assignAST.getParent();
        if (parentAST.getType() == 28) {
            nameAST = assignAST.findFirstToken(58);
        } else if (parentAST.getType() == 10) {
            nameAST = parentAST.findFirstToken(58);
        }
        if (nameAST != null) {
            return nameAST.getText();
        }
        return null;
    }

    private boolean _hasPrecedingVariableDef(DetailAST variableDefAST) {
        DetailAST previousSiblingAST = variableDefAST.getPreviousSibling();
        if (previousSiblingAST == null || previousSiblingAST.getType() != 45) {
            return false;
        }
        if ((previousSiblingAST = previousSiblingAST.getPreviousSibling()).getType() != 10) {
            return false;
        }
        return DetailASTUtil.getEndLineNumber(previousSiblingAST) + 1 == DetailASTUtil.getStartLineNumber(variableDefAST);
    }

    private boolean _isExpressionAssignsVariable(DetailAST detailAST, String name) {
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = detailAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        DetailAST expressionNameAST = childAST.findFirstToken(58);
        if (expressionNameAST == null) {
            return false;
        }
        String expressionName = expressionNameAST.getText();
        return expressionName.equals(name);
    }
}

