/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodNamingCheck
extends BaseCheck {
    private static final String _MSG_RENAME_METHOD = "method.rename";
    private static final Pattern _doMethodNamePattern = Pattern.compile("^_do([A-Z])(.*)$");
    private static final Pattern _nonMethodNamePattern = Pattern.compile("(^non|.*Non)([A-Z])(.*)");

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String methodName = this._getMethodName(detailAST);
        this._checkDoMethodName(detailAST, methodName);
        this._checkNonMethodName(detailAST, methodName);
    }

    private void _checkDoMethodName(DetailAST detailAST, String methodName) {
        Matcher matcher = _doMethodNamePattern.matcher(methodName);
        if (!matcher.find()) {
            return;
        }
        String noDoName = "_" + StringUtil.toLowerCase(matcher.group(1)) + matcher.group(2);
        String noUnderscoreName = methodName.substring(1);
        DetailAST parentAST = detailAST.getParent();
        List<DetailAST> methodDefASTList = DetailASTUtil.getAllChildTokens(parentAST, false, 9);
        for (DetailAST methodDefAST : methodDefASTList) {
            String curMethodName = this._getMethodName(methodDefAST);
            if (!curMethodName.equals(noUnderscoreName) && (!curMethodName.equals(noDoName) || !Objects.equals(DetailASTUtil.getSignature(detailAST), DetailASTUtil.getSignature(methodDefAST)))) continue;
            return;
        }
        this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, noDoName});
    }

    private void _checkNonMethodName(DetailAST detailAST, String methodName) {
        Matcher matcher = _nonMethodNamePattern.matcher(methodName);
        if (!matcher.find()) {
            return;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(matcher.group(1));
        sb.append(StringUtil.lowerCase(matcher.group(2)));
        String s = matcher.group(3);
        int i = StringUtil.startsWithWeight(s, StringUtil.upperCase(s));
        if (i == 0) {
            sb.append(s);
        } else {
            sb.append(StringUtil.lowerCase(s.substring(0, i - 1)));
            sb.append(s.substring(i - 1));
        }
        this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, sb.toString()});
    }

    private String _getMethodName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        return nameAST.getText();
    }
}

