/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndentationCheck
extends BaseCheck {
    private static final int[] _ARITHMETIC_OPERATORS = new int[]{127, 126, 128, 125, 60};
    private static final String _MSG_INCORRECT_INDENTATION = "indentation.incorrect";
    private static final String _MSG_INCORRECT_INDENTATION_INSIDE_CHAIN = "indentation.inside.chain.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{162, 29, 170, 145, 182, 138, 43, 175, 18, 39, 172, 58, 19, 30, 129, 11, 50, 86, 51, 93, 96, 52, 69, 87, 94, 85, 57, 92, 134, 97, 55, 91, 83, 54, 56, 136, 135, 61, 63, 62, 88, 53, 64, 79, 89, 67, 78, 90, 81, 133, 95, 49, 84, 132, 76, 142, 140, 137, 141, 16, 73, 77, 144, 152, 12, 139, 42, 23, 31, 167};
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        int leadingTabCount;
        if (!this._isAtLineStart(detailAST) || this._isCatchStatementParameter(detailAST) || this._isInsideChainedConcatMethod(detailAST) || this._isInsideDoIfOrWhileStatementCriterium(detailAST) || this._isInsideMethodParameterDeclaration(detailAST)) {
            return;
        }
        int expectedTabCount = this._getExpectedTabCount(detailAST);
        if (expectedTabCount != (leadingTabCount = this._getLeadingTabCount(detailAST))) {
            if (this._isInsideChain(detailAST)) {
                this.log(detailAST, _MSG_INCORRECT_INDENTATION_INSIDE_CHAIN, new Object[0]);
            } else {
                this.log(detailAST, _MSG_INCORRECT_INDENTATION, new Object[]{leadingTabCount, expectedTabCount});
            }
        }
    }

    private int _addExtraTabForExtendsOrImplements(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST;
        DetailAST grandParentAST = parentAST.getParent();
        while (grandParentAST != null) {
            if (grandParentAST.getType() == 18 || grandParentAST.getType() == 19) {
                DetailAST previousSiblingAST = parentAST.getPreviousSibling();
                if (previousSiblingAST == null || previousSiblingAST.getType() != 74) {
                    return expectedTabCount;
                }
                int lineNo = grandParentAST.getLineNo();
                if (lineNo < detailAST.getLineNo()) {
                    return expectedTabCount + 1;
                }
            }
            parentAST = grandParentAST;
            grandParentAST = grandParentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForForStatement(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = this._findParent(detailAST, 91);
        if (parentAST != null && parentAST.branchContains(156)) {
            return expectedTabCount + 1;
        }
        return expectedTabCount;
    }

    private int _addExtraTabForParameterWithThrows(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST;
        DetailAST grandParentAST = parentAST.getParent();
        while (grandParentAST != null) {
            if (grandParentAST.getType() == 8 || grandParentAST.getType() == 9) {
                DetailAST literalThrowsAST = grandParentAST.findFirstToken(81);
                if (literalThrowsAST == null) {
                    return expectedTabCount;
                }
                int literalThrowsLineNo = literalThrowsAST.getLineNo();
                int modifierLineNo = this._getModifierLineNo(grandParentAST);
                if (parentAST.getType() == 20 || detailAST.getLineNo() < literalThrowsLineNo && detailAST.getLineNo() > modifierLineNo) {
                    return expectedTabCount + 1;
                }
                return expectedTabCount;
            }
            parentAST = grandParentAST;
            grandParentAST = grandParentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForSwitch(int expectedTabCount, DetailAST detailAST) {
        if (detailAST.getType() == 93 || detailAST.getType() == 94) {
            return expectedTabCount;
        }
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 33) {
                return expectedTabCount + 1;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabForTryStatement(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            DetailAST previousSiblingAST;
            if (parentAST.getType() == 178 && (previousSiblingAST = parentAST.getPreviousSibling()) != null) {
                return expectedTabCount;
            }
            if (parentAST.getType() == 176) {
                if ((parentAST = parentAST.getParent()).getType() != 95) continue;
                return expectedTabCount + 1;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLambda(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            DetailAST grandParentAST;
            if (parentAST.getType() == 20 && (parentAST = parentAST.getParent()).getType() == 181 && (grandParentAST = parentAST.getParent()).getType() == 88) {
                return expectedTabCount + 1;
            }
            if (parentAST.getType() == 7) {
                DetailAST firstChildAST;
                if ((parentAST = parentAST.getParent()).getType() != 181 || (firstChildAST = parentAST.getFirstChild()).getLineNo() != parentAST.getLineNo()) continue;
                expectedTabCount += this._getLineBreakTabs(parentAST);
                continue;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private int _addExtraTabsForLiteralNew(int expectedTabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 6) {
                if ((parentAST = parentAST.getParent()).getType() != 136) continue;
                expectedTabCount += this._getLineBreakTabs(parentAST);
                continue;
            }
            parentAST = parentAST.getParent();
        }
        return expectedTabCount;
    }

    private Set<Integer> _addTabsForArithmeticOperators(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        DetailAST firstChildAST = detailAST;
        while (true) {
            int lineNo;
            if ((lineNo = firstChildAST.getLineNo()) < lineNumber) {
                lineNumbers.add(lineNo);
            }
            if (!ArrayUtil.contains(_ARITHMETIC_OPERATORS, firstChildAST.getType())) break;
            firstChildAST = firstChildAST.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForDot(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        DetailAST firstChildAST = detailAST;
        while (firstChildAST.getType() == 59) {
            int lineNo = firstChildAST.getLineNo();
            if (lineNo < lineNumber) {
                lineNumbers.add(lineNo);
            }
            firstChildAST = firstChildAST.getFirstChild();
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForGenerics(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        if (detailAST == null) {
            return lineNumbers;
        }
        List<DetailAST> genericStartASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 172);
        for (DetailAST genericStartAST : genericStartASTList) {
            DetailAST exprAST;
            DetailAST commaAST;
            DetailAST grandParentAST;
            DetailAST nextSiblingAST;
            DetailAST parentAST;
            DetailAST genericEndAST;
            if (!this._isAtLineStart(genericStartAST) || (genericEndAST = (parentAST = genericStartAST.getParent()).findFirstToken(173)).getLineNo() < lineNumber && genericStartAST.getLineNo() < lineNumber && (nextSiblingAST = (grandParentAST = parentAST.getParent()).getNextSibling()) != null && nextSiblingAST.getType() == 74) continue;
            int lineNo = genericStartAST.getLineNo() - 1;
            if (lineNo < lineNumber) {
                lineNumbers.add(lineNo);
            }
            if ((commaAST = parentAST.findFirstToken(74)) != null && genericEndAST.getLineNo() != genericStartAST.getLineNo() || (exprAST = DetailASTUtil.getParentWithTokenType(genericStartAST, 28)) != null && !lineNumbers.contains(DetailASTUtil.getStartLineNumber(exprAST)) || (lineNo = genericStartAST.getLineNo()) >= lineNumber) continue;
            lineNumbers.add(lineNo);
        }
        List<DetailAST> genericEndtASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 173);
        for (DetailAST genericEndAST : genericEndtASTList) {
            int lineNo;
            DetailAST exprAST;
            String line;
            if (!DetailASTUtil.isAtLineEnd(genericEndAST, line = this.getLine(genericEndAST.getLineNo() - 1)) || (exprAST = DetailASTUtil.getParentWithTokenType(genericEndAST, 28)) != null && !lineNumbers.contains(DetailASTUtil.getStartLineNumber(exprAST)) || (lineNo = genericEndAST.getLineNo()) >= lineNumber) continue;
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private Set<Integer> _addTabsForTypecast(Set<Integer> lineNumbers, int lineNumber, DetailAST detailAST) {
        DetailAST previousSiblingAST = detailAST.getPreviousSibling();
        if (previousSiblingAST == null || previousSiblingAST.getType() != 23) {
            return lineNumbers;
        }
        int lineNo = previousSiblingAST.getLineNo();
        if (lineNo < lineNumber) {
            lineNumbers.add(lineNo);
        }
        return lineNumbers;
    }

    private int _adjustTabCount(int tabCount, DetailAST detailAST) {
        tabCount = this._adjustTabCountForChains(tabCount, detailAST);
        tabCount = this._adjustTabCountForEndOfLineLogicalOperator(tabCount, detailAST);
        return tabCount;
    }

    private int _adjustTabCountForChains(int tabCount, DetailAST detailAST) {
        boolean checkChaining = false;
        int methodCallLineNumber = -1;
        DetailAST parentAST = detailAST;
        while (parentAST != null && parentAST.getType() != 22 && parentAST.getType() != 6 && parentAST.getType() != 7) {
            String line;
            if (checkChaining && (line = StringUtil.trim(this.getLine(parentAST.getLineNo() - 1))).endsWith("(") && parentAST.getLineNo() < methodCallLineNumber) {
                DetailAST rparenAST = null;
                DetailAST methodCallAST = this._findDetailAST(parentAST, parentAST.getLineNo(), 27);
                if (methodCallAST != null) {
                    rparenAST = methodCallAST.findFirstToken(77);
                } else {
                    DetailAST lparenAST = this._findDetailAST(parentAST, parentAST.getLineNo(), 76);
                    DetailAST nextSiblingAST = lparenAST.getNextSibling();
                    while (true) {
                        if (nextSiblingAST == null || nextSiblingAST.getType() == 77) {
                            rparenAST = nextSiblingAST;
                            break;
                        }
                        nextSiblingAST = nextSiblingAST.getNextSibling();
                    }
                }
                if (rparenAST != null && rparenAST.getLineNo() < detailAST.getLineNo()) {
                    --tabCount;
                }
                checkChaining = false;
            }
            if (parentAST.getType() == 27 && (line = StringUtil.trim(this.getLine(parentAST.getLineNo() - 1))).startsWith(").") && parentAST.getLineNo() < detailAST.getLineNo()) {
                checkChaining = true;
                methodCallLineNumber = parentAST.getLineNo();
            }
            parentAST = parentAST.getParent();
        }
        return tabCount;
    }

    private int _adjustTabCountForEndOfLineLogicalOperator(int tabCount, DetailAST detailAST) {
        DetailAST parentAST = detailAST;
        while (parentAST != null && parentAST.getType() != 22 && parentAST.getType() != 6 && parentAST.getType() != 7) {
            if ((parentAST.getType() == 114 || parentAST.getType() == 112 || parentAST.getType() == 113 || parentAST.getType() == 111 || parentAST.getType() == 110) && parentAST.getLineNo() < detailAST.getLineNo()) {
                String text = parentAST.getText();
                String line = this.getLine(parentAST.getLineNo() - 1);
                String trimmedLine = StringUtil.trim(line);
                if (!trimmedLine.startsWith("return ") && parentAST.getColumnNo() + text.length() == line.length()) {
                    --tabCount;
                }
            }
            parentAST = parentAST.getParent();
        }
        return tabCount;
    }

    private DetailAST _findDetailAST(DetailAST parentAST, int lineNo, int type) {
        if (parentAST.getType() == type) {
            return parentAST;
        }
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(parentAST, true, type);
        for (DetailAST methodCallAST : methodCallASTList) {
            if (methodCallAST.getLineNo() != lineNo) continue;
            return methodCallAST;
        }
        return null;
    }

    private DetailAST _findParent(DetailAST detailAST, int type) {
        DetailAST match = null;
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null && parentAST.getType() != 6 && parentAST.getType() != 7) {
            if (parentAST.getType() == type) {
                match = parentAST;
            }
            parentAST = parentAST.getParent();
        }
        return match;
    }

    private int _getChainLevel(DetailAST detailAST) {
        int level = 1;
        while (true) {
            DetailAST firstChildAST = detailAST.getFirstChild();
            if (detailAST.getType() == 27 && firstChildAST.getType() == 59) {
                detailAST = firstChildAST;
                continue;
            }
            if (detailAST.getType() != 59 || firstChildAST.getType() != 27) break;
            ++level;
            detailAST = firstChildAST;
        }
        return level;
    }

    private int _getExpectedTabCount(DetailAST detailAST) {
        DetailAST previousSiblingAST = detailAST.getPreviousSibling();
        if (previousSiblingAST != null && previousSiblingAST.getType() == 74 && this._isAtLineStart(previousSiblingAST = previousSiblingAST.getPreviousSibling())) {
            return this._getExpectedTabCount(previousSiblingAST);
        }
        int expectedTabCount = this._getLevel(detailAST) + this._getLineBreakTabs(detailAST);
        expectedTabCount = this._addExtraTabForExtendsOrImplements(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForForStatement(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLambda(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabsForLiteralNew(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForParameterWithThrows(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForSwitch(expectedTabCount, detailAST);
        expectedTabCount = this._addExtraTabForTryStatement(expectedTabCount, detailAST);
        if (detailAST.getType() == 182 || detailAST.getType() == 73 || detailAST.getType() == 77) {
            return expectedTabCount - 1;
        }
        return expectedTabCount;
    }

    private int _getLeadingTabCount(DetailAST detailAST) {
        String line = this.getLine(DetailASTUtil.getStartLineNumber(detailAST) - 1);
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private int _getLevel(DetailAST detailAST) {
        int level = 0;
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (parentAST.getType() == 6 || parentAST.getType() == 7) {
                ++level;
            }
            parentAST = parentAST.getParent();
        }
        return level;
    }

    private int _getLineBreakTabs(DetailAST detailAST) {
        if (detailAST.getType() == 175 || detailAST.getType() == 96 || detailAST.getType() == 92 || detailAST.getType() == 97) {
            return 0;
        }
        Set<Integer> lineNumbers = new HashSet<Integer>();
        DetailAST parentAST = detailAST;
        while (parentAST != null && parentAST.getType() != 22 && parentAST.getType() != 6 && parentAST.getType() != 7) {
            DetailAST colonAST;
            int lineNo;
            DetailAST nameAST;
            int lineNo2;
            if (parentAST.getType() == 157 || parentAST.getType() == 161 || parentAST.getType() == 14 || parentAST.getType() == 8 || parentAST.getType() == 155 || parentAST.getType() == 154 || parentAST.getType() == 15 || parentAST.getType() == 9 || parentAST.getType() == 5 || parentAST.getType() == 10) {
                DetailAST nameAST2;
                DetailAST typeAST = parentAST.findFirstToken(13);
                int lineNo3 = this._getModifierLineNo(parentAST);
                if (lineNo3 == -1 && typeAST != null) {
                    lineNo3 = typeAST.getLineNo();
                }
                if (lineNo3 != -1 && lineNo3 < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                if ((parentAST.getType() == 14 || parentAST.getType() == 155 || parentAST.getType() == 154 || parentAST.getType() == 15) && (lineNo3 = (nameAST2 = parentAST.findFirstToken(58)).getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo3);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeAST);
                DetailAST typeParametersAST = parentAST.findFirstToken(165);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeParametersAST);
            } else if (parentAST.getType() == 34 || parentAST.getType() == 20) {
                int lineNo4;
                DetailAST lParenAST = parentAST.getPreviousSibling();
                if (lParenAST != null && lParenAST.getType() == 76 && !this._isAtLineStart(lParenAST) && (lineNo4 = lParenAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo4);
                }
            } else if (parentAST.getType() == 163 || parentAST.getType() == 165) {
                int lineNo5;
                DetailAST commaAST = parentAST.findFirstToken(74);
                if ((commaAST == null || commaAST.getLineNo() != parentAST.getLineNo() && commaAST.getLineNo() >= detailAST.getLineNo()) && (lineNo5 = parentAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo5);
                }
            } else if (parentAST.getType() != 33 && (lineNo2 = parentAST.getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo2);
            }
            DetailAST dotAST = parentAST.findFirstToken(59);
            lineNumbers = this._addTabsForDot(lineNumbers, detailAST.getLineNo(), dotAST);
            if ((parentAST.getType() == 18 || parentAST.getType() == 19) && (nameAST = parentAST.findFirstToken(58)) != null && (lineNo = nameAST.getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo);
            }
            if (parentAST.getType() == 156) {
                DetailAST colonAST2 = parentAST.findFirstToken(82);
                if (colonAST2 != null && (lineNo = colonAST2.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo);
                }
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 21) {
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 109 && (lineNo = (colonAST = parentAST.findFirstToken(82)).getLineNo()) < detailAST.getLineNo()) {
                lineNumbers.add(lineNo);
            }
            if (ArrayUtil.contains(_ARITHMETIC_OPERATORS, parentAST.getType())) {
                lineNumbers = this._addTabsForArithmeticOperators(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 13) {
                lineNumbers = this._addTabsForTypecast(lineNumbers, detailAST.getLineNo(), parentAST);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), parentAST);
            }
            if (parentAST.getType() == 23) {
                int lineNo6;
                String line;
                DetailAST rparenAST = parentAST.findFirstToken(77);
                if (DetailASTUtil.isAtLineEnd(rparenAST, line = this.getLine(rparenAST.getLineNo() - 1)) && (lineNo6 = rparenAST.getLineNo()) < detailAST.getLineNo()) {
                    lineNumbers.add(lineNo6);
                }
                DetailAST typeAST = parentAST.findFirstToken(13);
                lineNumbers = this._addTabsForGenerics(lineNumbers, detailAST.getLineNo(), typeAST);
            }
            if (parentAST.getType() == 159) {
                if ((parentAST = parentAST.getParent()).getType() != 5 || this._findParent(parentAST, 21) != null) continue;
                return this._adjustTabCount(lineNumbers.size(), detailAST);
            }
            parentAST = parentAST.getParent();
        }
        return this._adjustTabCount(lineNumbers.size(), detailAST);
    }

    private int _getModifierLineNo(DetailAST detailAST) {
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (modifiersAST == null) {
            return -1;
        }
        DetailAST modifierAST = modifiersAST.findFirstToken(61);
        if (modifierAST == null) {
            modifierAST = modifiersAST.findFirstToken(63);
        }
        if (modifierAST == null) {
            modifierAST = modifiersAST.findFirstToken(62);
        }
        if (modifierAST != null) {
            return modifierAST.getLineNo();
        }
        return -1;
    }

    private boolean _isAtLineStart(DetailAST detailAST) {
        String line = this.getLine(DetailASTUtil.getStartLineNumber(detailAST) - 1);
        for (int i = 0; i < detailAST.getColumnNo(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private boolean _isCatchStatementParameter(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() != 21) {
                parentAST = parentAST.getParent();
                continue;
            }
            if ((parentAST = parentAST.getParent()).getType() == 96) break;
        }
        return true;
    }

    private boolean _isConcatMethod(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return false;
        }
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() != 59) {
            return false;
        }
        DetailAST lastChildAST = firstChildAST.getLastChild();
        if (lastChildAST == null || lastChildAST.getType() != 58) {
            return false;
        }
        String name = lastChildAST.getText();
        return name.equals("concat");
    }

    private boolean _isInsideChain(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null && parentAST.getType() != 7) {
            if (parentAST.getType() == 27 && this._getChainLevel(parentAST) > 2) {
                return true;
            }
            parentAST = parentAST.getParent();
        }
        return false;
    }

    private boolean _isInsideChainedConcatMethod(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (parentAST != null) {
            if (!this._isConcatMethod(parentAST)) {
                parentAST = parentAST.getParent();
                continue;
            }
            DetailAST firstChildAST = parentAST.getFirstChild();
            if (this._isConcatMethod(firstChildAST = firstChildAST.getFirstChild())) {
                return true;
            }
            parentAST = parentAST.getParent();
        }
        return false;
    }

    private boolean _isInsideDoIfOrWhileStatementCriterium(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() != 28) {
                parentAST = parentAST.getParent();
                continue;
            }
            if ((parentAST = parentAST.getParent()).getType() == 85 || parentAST.getType() == 83 || parentAST.getType() == 84) break;
        }
        return true;
    }

    private boolean _isInsideMethodParameterDeclaration(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        while (true) {
            if (parentAST == null) {
                return false;
            }
            if (parentAST.getType() == 21) break;
            parentAST = parentAST.getParent();
        }
        parentAST = parentAST.getParent();
        if (parentAST.getType() != 20) {
            return false;
        }
        return (parentAST = parentAST.getParent()).getType() == 8 || parentAST.getType() == 9;
    }
}

