/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseEnumConstantCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class EnumConstantDividerCheck
extends BaseEnumConstantCheck {
    private static final String _MSG_UNNECESSARY_EMPTY_LINE = "empty.line.unnecessary";

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nextEnumConstantDefAST = this.getNextEnumConstantDefAST(detailAST);
        if (nextEnumConstantDefAST != null) {
            this._checkDivider(detailAST, nextEnumConstantDefAST);
        }
    }

    private void _checkDivider(DetailAST enumConstantDefAST1, DetailAST enumConstantDefAST2) {
        int startLineNumberConstant2;
        int endLineNumberConstant1 = DetailASTUtil.getEndLineNumber(enumConstantDefAST1);
        if (endLineNumberConstant1 == (startLineNumberConstant2 = DetailASTUtil.getStartLineNumber(enumConstantDefAST2))) {
            return;
        }
        String nextLine = this.getLine(endLineNumberConstant1);
        String nextNextLine = StringUtil.trim(this.getLine(endLineNumberConstant1 + 1));
        if (Validator.isNull(nextLine) && !nextNextLine.startsWith("/")) {
            this.log(endLineNumberConstant1 + 1, _MSG_UNNECESSARY_EMPTY_LINE, new Object[0]);
        }
    }
}

