/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesPortalEnvironmentVariablesCheck
extends BaseFileCheck {
    private static final String _ENV_OVERRIDE_PREFIX = "LIFERAY_";
    private static final Map<Character, String> _charPoolChars = new HashMap<Character, String>(){
        {
            try {
                for (Field field : CharPool.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Character.TYPE) continue;
                    this.put(Character.valueOf(field.getChar(null)), StringUtil.removeChar(field.getName(), '_'));
                }
            }
            catch (ReflectiveOperationException roe) {
                throw new ExceptionInInitializerError(roe);
            }
        }
    };
    private static final Pattern _pattern = Pattern.compile("    #\\n(    # (?!Env:).*\\n)+    #(\\n(    # Env:.*\\n)+    #)?((\\n    [#\\w][#\\w].*)+)", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!this.isPortalSource()) {
            return content;
        }
        if (!fileName.matches(".*/portal-impl/src/portal(_.*)?\\.properties")) {
            return content;
        }
        return this._formatPortalProperties(content);
    }

    private String _encode(String s) {
        StringBundler sb = new StringBundler();
        sb.append(_ENV_OVERRIDE_PREFIX);
        for (char c : s.toCharArray()) {
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append('_');
            sb.append(_charPoolChars.get(Character.valueOf(c)));
            sb.append('_');
        }
        return sb.toString();
    }

    private String _formatPortalProperties(String content) {
        Matcher matcher = _pattern.matcher(content);
        while (matcher.find()) {
            String blockComment;
            StringBundler sb = new StringBundler();
            String match = matcher.group(4);
            Set<String> environmentVariables = this._getEnviornmentVariables(match);
            for (String environmentVariable : environmentVariables) {
                sb.append("\n");
                sb.append("    ");
                sb.append("# Env: ");
                sb.append(environmentVariable);
            }
            if (!environmentVariables.isEmpty()) {
                sb.append("\n");
                sb.append("    ");
                sb.append("#");
            }
            if ((blockComment = matcher.group(2)) == null) {
                content = StringUtil.replaceFirst(content, match, sb.toString() + match);
                continue;
            }
            if (blockComment.equals(sb.toString())) continue;
            content = StringUtil.replaceFirst(content, blockComment, sb.toString());
        }
        return content;
    }

    private Set<String> _getEnviornmentVariables(String s) {
        TreeSet<String> environmentVariables = new TreeSet<String>();
        for (String line : StringUtil.splitLines(s)) {
            String[] array;
            String trimmedLine = StringUtil.trim(line);
            if (trimmedLine.startsWith("#")) {
                trimmedLine = trimmedLine.substring(1);
                trimmedLine = StringUtil.trim(trimmedLine);
            }
            if ((array = trimmedLine.split("=", 2)).length < 1) continue;
            environmentVariables.add(this._encode(array[0]));
        }
        return environmentVariables;
    }
}

