/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class PropertiesLanguageKeysOrderCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties")) {
            return content;
        }
        int x = absolutePath.lastIndexOf("/");
        File dir = new File(absolutePath.substring(0, x + 1));
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String s = StringUtil.toLowerCase(name);
                return s.startsWith("language_") && s.endsWith(".properties");
            }
        });
        if (files.length > 1) {
            return content;
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            TreeMap<String, String> messagesMap = new TreeMap<String, String>(new NaturalOrderStringComparator(true, true));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] array = line.split("=", 2);
                if (array.length > 1) {
                    messagesMap.put(array[0], array[1]);
                    continue;
                }
                for (Map.Entry entry : messagesMap.entrySet()) {
                    sb.append((String)entry.getKey());
                    sb.append("=");
                    sb.append((String)entry.getValue());
                    sb.append("\n");
                }
                if (!messagesMap.isEmpty()) {
                    messagesMap.clear();
                }
                sb.append(line);
                sb.append("\n");
            }
            for (Map.Entry entry : messagesMap.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append("=");
                sb.append((String)entry.getValue());
                sb.append("\n");
            }
            if (!messagesMap.isEmpty()) {
                messagesMap.clear();
            }
        }
        return StringUtil.trim(sb.toString());
    }
}

