/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.StylingCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStylingCheck
extends StylingCheck {
    private static final Pattern _incorrectJavadocPattern = Pattern.compile("(\n([\t ]*)/\\*)(\n\\2 \\*)");
    private static final Pattern _incorrectSynchronizedPattern = Pattern.compile("([\n\t])(synchronized) (private|public|protected)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (content.contains("$\n */")) {
            content = StringUtil.replace(content, "$\n */", "$\n *\n */");
        }
        if (content.contains(" * @author Raymond Aug") && !content.contains(" * @author Raymond Aug\u00e9")) {
            content = content.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
        }
        content = StringUtil.replace(content, " final static ", " static final ");
        content = StringUtil.replace(content, new String[]{";\n/**", ";;\n", "\n */\npackage "}, new String[]{";\n\n/**", ";\n", "\n */\n\npackage "});
        Matcher matcher = _incorrectSynchronizedPattern.matcher(content);
        content = matcher.replaceAll("$1$3 $2");
        matcher = _incorrectJavadocPattern.matcher(content);
        content = matcher.replaceAll("$1*$3");
        return this.formatStyling(content);
    }
}

