/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.LineBreakCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLineBreakCheck
extends LineBreakCheck {
    private static final Pattern _arrayPattern = Pattern.compile("(\n\t*.* =) ((new \\w*\\[\\] )?\\{)\n(\t*)([^\t\\{].*)\n\t*(\\};?)\n");
    private static final Pattern _catchStatemementPattern = Pattern.compile("\n((\t*)catch \\((.*[^{|\\s])?\n[^}]*?\\) \\{)\n");
    private static final Pattern _classOrEnumPattern = Pattern.compile("(\n(\t*)(private|protected|public) ((abstract|final|static) )*(class|enum|interface) ([\\s\\S]*?)\\{)((.*)\\})?([ \t]*(\\Z|\n)(\\s*)(\\S))");
    private static final Pattern _incorrectExtendImplementPattern1 = Pattern.compile(" (extends|implements)\n(\t+)");
    private static final Pattern _incorrectExtendImplementPattern2 = Pattern.compile("\n((\t+)(extends|implements)\n\t+(\\w+))\n");
    private static final Pattern _incorrectLineBreakInsideChainPattern1 = Pattern.compile("\n(\t*)\\).*?\\((.+)");
    private static final Pattern _incorrectLineBreakInsideChainPattern2 = Pattern.compile("\t\\)\\..*\\(\n");
    private static final Pattern _incorrectLineBreakInsideChainPattern3 = Pattern.compile("\n(.*\\S)\\)\\.(.*)\\(\n");
    private static final Pattern _incorrectLineBreakInsideChainPattern4 = Pattern.compile("\t(\\)\\.[^\\)\\(]+\\()(.+)\n");
    private static final Pattern _incorrectLineBreakPattern1 = Pattern.compile("\n(\t*)(.*\\) \\{)([\t ]*\\}\n)");
    private static final Pattern _incorrectLineBreakPattern2 = Pattern.compile("\n(\t*).*\\}\n(\t*)\\);");
    private static final Pattern _incorrectLineBreakPattern3 = Pattern.compile("\n(\t*)\\{.+(?<!\\}\\){0,10}(,|;)?)\n");
    private static final Pattern _incorrectLineBreakPattern4 = Pattern.compile("\n(\t+\\{)\n(.*[^;])\n\t+(\\},?)");
    private static final Pattern _incorrectLineBreakPattern5 = Pattern.compile(", (new .*\\(.*\\) \\{)\n");
    private static final Pattern _incorrectLineBreakPattern6 = Pattern.compile("^(((else )?if|for|try|while) \\()?\\(*(.*\\()$");
    private static final Pattern _incorrectLineBreakPattern7 = Pattern.compile("(\t+)for \\(.*:(.+\\()\n[\\s\\S]+?\\) \\{\n");
    private static final Pattern _incorrectMultiLineCommentPattern = Pattern.compile("(\n\t*/\\*)\n\t*(.*?)\n\t*(\\*/\n)", 32);
    private static final Pattern _lineStartingWithCloseParenthesisPattern = Pattern.compile("(.)\n+(\t+)\\)[^.].*\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws CheckstyleException, IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.startsWith(";")) {
                    this.addMessage(fileName, "Line should not start with ';'", lineNumber);
                }
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*") && trimmedLine.startsWith(".")) {
                    this.addMessage(fileName, "Line should not start with '.'", lineNumber);
                }
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || trimmedLine.startsWith("*") || lineLength > this.getMaxLineLength())) {
                    this._checkLineBreaks(line, previousLine, fileName, lineNumber);
                }
                previousLine = line;
            }
        }
        content = this._fixIncorrectCatchStatementLineBreaks(content);
        content = this._fixIncorrectLineBreaksInsideChains(content, fileName);
        content = this._fixIncorrectLineBreaks(content, fileName);
        content = this._fixLineStartingWithCloseParenthesis(content, fileName);
        content = this._fixMultiLineComment(content);
        content = this._fixArrayLineBreaks(content);
        content = this._fixClassOrEnumLineLineBreaks(content);
        content = this.fixRedundantCommaInsideArray(content);
        return content;
    }

    private void _checkLambdaLineBreaks(String line, String fileName, int lineNumber) {
        if (!line.endsWith("{") || this.getLevel(line) <= 0) {
            return;
        }
        int pos = line.indexOf("->");
        if (pos == -1 || ToolsUtil.isInsideQuotes(line, pos)) {
            return;
        }
        int x = 1;
        while (true) {
            String s;
            if (this.getLevel(s = line.substring(0, x)) > 0) {
                this.addMessage(fileName, "There should be a line break after '" + s + "'", lineNumber);
                return;
            }
            ++x;
        }
    }

    private void _checkLineBreaks(String line, String previousLine, String fileName, int lineNumber) {
        int x;
        Matcher matcher;
        int x2;
        this.checkLineBreaks(line, previousLine, fileName, lineNumber);
        String trimmedLine = StringUtil.trimLeading(line);
        if (previousLine.contains("\t/*") || trimmedLine.startsWith("//") | trimmedLine.startsWith("/*") || trimmedLine.endsWith("*/")) {
            return;
        }
        this._checkLambdaLineBreaks(trimmedLine, fileName, lineNumber);
        if (trimmedLine.endsWith("( {")) {
            this.addMessage(fileName, "There should be a line before ' {'", lineNumber);
        }
        int x3 = 0;
        while ((x3 = trimmedLine.indexOf("}", x3 + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(trimmedLine, x3) || this.getLevel(trimmedLine.substring(0, x3 + 1), "{", "}") >= 0) continue;
            this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x3) + "'", lineNumber);
        }
        if (previousLine.endsWith(".") && (x3 = trimmedLine.indexOf(40)) != -1 && this.getLineLength(previousLine) + x3 < this.getMaxLineLength() && (trimmedLine.endsWith("(") || trimmedLine.charAt(x3 + 1) != ')')) {
            this.addMessage(fileName, "Incorrect line break", lineNumber);
        }
        String strippedQuotesLine = this.stripQuotes(trimmedLine);
        if (line.matches(".*(\\(|->( \\{)?)")) {
            String linePart;
            int pos;
            int y;
            x2 = line.lastIndexOf(" && ");
            int z = Math.max(x2, y = line.lastIndexOf(" || "));
            if (z != -1) {
                this.addMessage(fileName, "There should be a line break after '" + line.substring(z + 1, z + 3) + "'", lineNumber);
            }
            if ((pos = strippedQuotesLine.indexOf(" + ")) != -1 && this.getLevel(linePart = strippedQuotesLine.substring(0, pos), "(", ")") == 0 && this.getLevel(linePart, "[", "]") == 0) {
                this.addMessage(fileName, "There should be a line break after '+'", lineNumber);
            }
        }
        if (line.matches(".*(\\(|\\^|\\&|\\||->( \\{)?)")) {
            x2 = trimmedLine.length() + 1;
            while ((x2 = trimmedLine.lastIndexOf(",", x2 - 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x2)) continue;
                String linePart = trimmedLine.substring(x2, trimmedLine.length() - 1);
                if (this.getLevel(linePart = StringUtil.removeSubstring(linePart, "->")) != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x2 + 1) + "'", lineNumber);
                break;
            }
        }
        if (trimmedLine.matches("^[^(].*\\+$") && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "There should be a line break after '('", lineNumber);
        }
        if (!trimmedLine.contains("\t//") && !line.endsWith("{") && strippedQuotesLine.contains("{") && !strippedQuotesLine.contains("}")) {
            this.addMessage(fileName, "There should be a line break after '{'", lineNumber);
        }
        if (line.endsWith(" throws") || (previousLine.endsWith(",") || previousLine.endsWith("(")) && line.contains(" throws ") && (line.endsWith("{") || line.endsWith(";"))) {
            this.addMessage(fileName, "There should be a line break before 'throws'", lineNumber);
        }
        if (line.endsWith(".") && line.contains("=")) {
            this.addMessage(fileName, "There should be a line break after '='", lineNumber);
        }
        if (trimmedLine.matches("^\\} (catch|else|finally) .*")) {
            this.addMessage(fileName, "There should be a line break after '}'", lineNumber);
        }
        if ((matcher = _incorrectLineBreakPattern6.matcher(trimmedLine)).find() && this.getLevel(matcher.group(4)) > 1) {
            x = trimmedLine.indexOf("(", matcher.start(4));
            String linePart = trimmedLine.substring(0, x + 1);
            this.addMessage(fileName, "There should be a line break after '" + linePart + "'", lineNumber);
        }
        if (trimmedLine.matches("for \\(.*[^;{]")) {
            x = trimmedLine.length();
            while ((x = trimmedLine.lastIndexOf(";", x - 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x)) continue;
                this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x + 1) + "'", lineNumber);
            }
        }
    }

    private String _fixArrayLineBreaks(String content) {
        Matcher matcher = _arrayPattern.matcher(content);
        while (matcher.find()) {
            String newLine = matcher.group(4) + matcher.group(2) + matcher.group(5) + matcher.group(6);
            if (this.getLineLength(newLine) > this.getMaxLineLength()) continue;
            return StringUtil.replace(content, matcher.group(), StringBundler.concat(matcher.group(1), "\n", newLine, "\n"));
        }
        return content;
    }

    private String _fixClassOrEnumLineLineBreaks(String content) {
        Matcher matcher = _classOrEnumPattern.matcher(content);
        while (matcher.find()) {
            String indent = matcher.group(2);
            String match = matcher.group(1);
            String inBetweenCurlyBraces = matcher.group(9);
            if (inBetweenCurlyBraces != null) {
                if (Validator.isNull(inBetweenCurlyBraces)) {
                    return StringUtil.replaceFirst(content, "}", "\n" + indent + "}", matcher.end(9));
                }
                return StringUtil.replaceFirst(content, inBetweenCurlyBraces + "}", StringBundler.concat("\n\n\t", indent, StringUtil.trim(inBetweenCurlyBraces), "\n\n", indent, "}"), matcher.start(8));
            }
            String firstTrailingNonWhitespace = matcher.group(13);
            String trailingWhitespace = matcher.group(12);
            if (!trailingWhitespace.contains("\n") && !firstTrailingNonWhitespace.equals("}")) {
                return StringUtil.replace(content, match, match + "\n");
            }
            String formattedClassLine = this._getFormattedClassLine(indent, match);
            if (formattedClassLine == null) continue;
            content = StringUtil.replace(content, match, formattedClassLine);
        }
        return content;
    }

    private String _fixIncorrectCatchStatementLineBreaks(String content) {
        Matcher matcher = _catchStatemementPattern.matcher(content);
        while (matcher.find()) {
            String thirdLine;
            String secondLine;
            String newCatchStatement;
            String indent;
            String catchStatement = matcher.group(1);
            String singleLineCatchStatement = indent = matcher.group(2);
            for (String line : StringUtil.splitLines(catchStatement)) {
                if (!(singleLineCatchStatement.equals(indent) || singleLineCatchStatement.endsWith("(") || singleLineCatchStatement.endsWith("."))) {
                    singleLineCatchStatement = singleLineCatchStatement + " ";
                }
                singleLineCatchStatement = singleLineCatchStatement + StringUtil.trim(line);
            }
            if (this.getLineLength(singleLineCatchStatement) <= this.getMaxLineLength()) {
                return StringUtil.replaceFirst(content, catchStatement, singleLineCatchStatement, matcher.start());
            }
            int x = this._getLastIndexOf(singleLineCatchStatement, '|', this.getMaxLineLength());
            if (x != -1) {
                String newCatchStatement2 = StringUtil.insert(singleLineCatchStatement, "\n" + indent, x + 1);
                if (catchStatement.equals(newCatchStatement2)) continue;
                return StringUtil.replaceFirst(content, catchStatement, newCatchStatement2, matcher.start());
            }
            if (singleLineCatchStatement.contains("|")) continue;
            x = singleLineCatchStatement.indexOf(40);
            String firstLine = singleLineCatchStatement.substring(0, x + 1);
            String remainder = indent + "\t" + singleLineCatchStatement.substring(x + 1);
            if (this.getLineLength(remainder) <= this.getMaxLineLength()) {
                String newCatchStatement3 = firstLine + "\n" + remainder;
                if (catchStatement.equals(newCatchStatement3)) continue;
                return StringUtil.replaceFirst(content, catchStatement, newCatchStatement3, matcher.start());
            }
            x = this._getLastIndexOf(remainder, ' ', this.getMaxLineLength());
            if (x == -1) {
                x = this._getLastIndexOf(remainder, '.', this.getMaxLineLength());
            }
            if (x == -1 || catchStatement.equals(newCatchStatement = StringBundler.concat(firstLine, "\n", secondLine = remainder.substring(0, x + 1), "\n", thirdLine = indent + "\t\t" + remainder.substring(x + 1)))) continue;
            return StringUtil.replaceFirst(content, catchStatement, newCatchStatement, matcher.start());
        }
        return content;
    }

    private String _fixIncorrectLineBreaks(String content, String fileName) {
        Matcher matcher = _incorrectLineBreakPattern1.matcher(content);
        while (matcher.find()) {
            String matchingLine = matcher.group(2);
            if (matchingLine.startsWith("//") || matchingLine.startsWith("*")) continue;
            return StringUtil.replaceFirst(content, matcher.group(3), "\n" + matcher.group(1) + "}\n", matcher.start(3) - 1);
        }
        matcher = _incorrectLineBreakPattern2.matcher(content);
        while (matcher.find()) {
            String match;
            String tabs = matcher.group(2);
            Pattern pattern = Pattern.compile(StringBundler.concat("\n", tabs, "([^\t]{2})(?!.*\n", tabs, "[^\t])"), 32);
            Matcher matcher2 = pattern.matcher(content.substring(0, matcher.start(2)));
            if (!matcher2.find() || (match = matcher2.group(1)).equals(").")) continue;
            return StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.end(1));
        }
        matcher = _incorrectLineBreakPattern3.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group(), "{", "}") <= 0) continue;
            return StringUtil.replaceFirst(content, "{", "{\n" + matcher.group(1) + "\t", matcher.start());
        }
        matcher = _incorrectLineBreakPattern4.matcher(content);
        while (matcher.find()) {
            String singleLine;
            if (content.charAt(matcher.end()) != '\n' || this.getLineLength(singleLine = matcher.group(1) + StringUtil.trimLeading(matcher.group(2)) + matcher.group(3)) > this.getMaxLineLength()) continue;
            return StringUtil.replace(content, matcher.group(), "\n" + singleLine);
        }
        matcher = _incorrectLineBreakPattern7.matcher(content);
        while (matcher.find()) {
            String linePart = matcher.group(2);
            if (this.getLevel(linePart) != 1) continue;
            if (StringUtil.count(matcher.group(), '\n') > 2) {
                this.addMessage(fileName, "For better readability, create new var for the array in the 'for' statement", this.getLineNumber(content, matcher.start()));
                continue;
            }
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "\n\t", "\n\t\t");
            replacement = StringUtil.replaceFirst(replacement, linePart, "\n\t\t" + matcher.group(1) + StringUtil.trim(linePart));
            return StringUtil.replace(content, match, replacement);
        }
        matcher = _incorrectLineBreakPattern5.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) != 0) continue;
            int lineNumber = this.getLineNumber(content, matcher.start());
            this.addMessage(fileName, "There should be a line break before '" + matcher.group(1) + "'", lineNumber);
        }
        return content;
    }

    private String _fixIncorrectLineBreaksInsideChains(String content, String fileName) {
        Matcher matcher = _incorrectLineBreakInsideChainPattern1.matcher(content);
        while (matcher.find()) {
            String linePart = matcher.group(2);
            if (!linePart.matches("\\)[^\\)]+[\\(;]")) continue;
            return StringUtil.insert(content, "\n" + matcher.group(1), matcher.start(2));
        }
        matcher = _incorrectLineBreakInsideChainPattern2.matcher(content);
        while (matcher.find()) {
            String s;
            int x = matcher.end();
            do {
                if ((x = content.indexOf(")", x + 1)) != -1) continue;
                return content;
            } while (ToolsUtil.isInsideQuotes(content, x) || this.getLevel(s = content.substring(matcher.end(), x)) != 0);
            char c = content.charAt(x - 1);
            if (c == '\t') continue;
            int y = content.lastIndexOf("\t", x);
            s = content.substring(y + 1, x);
            this.addMessage(fileName, "There should be a line break after '" + s + "'", this.getLineNumber(content, x));
        }
        matcher = _incorrectLineBreakInsideChainPattern3.matcher(content);
        while (matcher.find()) {
            String methodName;
            if (this.getLevel(matcher.group(1)) > 0 || (methodName = matcher.group(2)).equals("concat")) continue;
            this.addMessage(fileName, "Chaining on method '" + methodName + "' is allowed, but incorrect styling", "chaining.markdown", this.getLineNumber(content, matcher.end(1)));
        }
        matcher = _incorrectLineBreakInsideChainPattern4.matcher(content);
        while (matcher.find()) {
            String s = matcher.group(2);
            if (s.matches("\\)+;?")) continue;
            this.addMessage(fileName, "There should be a line break after '" + matcher.group(1) + "'", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }

    private String _fixLineStartingWithCloseParenthesis(String content, String fileName) throws CheckstyleException {
        Matcher matcher = _lineStartingWithCloseParenthesisPattern.matcher(content);
        while (matcher.find()) {
            String lastCharacterPreviousLine = matcher.group(1);
            if (lastCharacterPreviousLine.equals("(")) {
                this.addMessage(fileName, "Line should not start with ')'", this.getLineNumber(content, matcher.start(1)));
                return content;
            }
            int x = matcher.end(2) + 1;
            int y = x - 1;
            while (ToolsUtil.isInsideQuotes(content, y) || this.getLevel(content.substring(y, x)) != 0) {
                --y;
            }
            String trimmedLine = StringUtil.trimLeading(this.getLine(content, this.getLineNumber(content, y)));
            if (trimmedLine.startsWith(").") || trimmedLine.startsWith("@") || this._hasAllowedChain(trimmedLine)) continue;
            return StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.start());
        }
        return content;
    }

    private String _fixMultiLineComment(String content) {
        Matcher matcher = _incorrectMultiLineCommentPattern.matcher(content);
        return matcher.replaceAll("$1$2$3");
    }

    private String _getFormattedClassLine(String indent, String classLine) {
        ArrayList<String> lines;
        block17: {
            while (classLine.contains("\t ")) {
                classLine = StringUtil.replace(classLine, "\t ", "\t");
            }
            String classSingleLine = StringUtil.replace(classLine.substring(1), new String[]{"\t", "\n"}, new String[]{"", " "});
            classSingleLine = indent + classSingleLine;
            lines = new ArrayList<String>();
            if (this.getLineLength(classSingleLine) <= this.getMaxLineLength()) {
                lines.add(classSingleLine);
            } else {
                int y;
                String newIndent = indent;
                String newLine = classSingleLine;
                int x = -1;
                while ((x = (y = newLine.indexOf(" extends ", x + 1)) == -1 ? newLine.indexOf(" implements ", x + 1) : y) != -1) {
                    String linePart = newLine.substring(0, x);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    if (lines.isEmpty()) {
                        newIndent = newIndent + "\t";
                    }
                    lines.add(linePart);
                    newLine = newIndent + newLine.substring(x + 1);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break block17;
                    }
                    x = -1;
                }
                if (lines.isEmpty()) {
                    return null;
                }
                x = newLine.length();
                while (true) {
                    if ((x = newLine.lastIndexOf(", ", x - 1)) == -1) {
                        String replacement;
                        Matcher matcher = _incorrectExtendImplementPattern1.matcher(classLine);
                        if (matcher.find()) {
                            replacement = StringBundler.concat("\n", matcher.group(2), matcher.group(1), " ");
                            return StringUtil.replaceFirst(classLine, matcher.group(), replacement);
                        }
                        matcher = _incorrectExtendImplementPattern2.matcher(classLine);
                        if (matcher.find() && this.getLineLength(replacement = StringBundler.concat(matcher.group(2), matcher.group(3), " ", matcher.group(4))) <= this.getMaxLineLength()) {
                            return StringUtil.replaceFirst(classLine, matcher.group(1), replacement);
                        }
                        return null;
                    }
                    String linePart = newLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    lines.add(linePart);
                    if (linePart.contains("\textends")) {
                        newIndent = newIndent + "\t\t";
                    } else if (linePart.contains("\timplements")) {
                        newIndent = newIndent + "\t\t   ";
                    }
                    newLine = newIndent + newLine.substring(x + 2);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break;
                    }
                    x = newLine.length();
                }
            }
        }
        String formattedClassLine = null;
        for (String line : lines) {
            if (formattedClassLine == null) {
                formattedClassLine = "\n" + line;
                continue;
            }
            formattedClassLine = formattedClassLine + "\n" + line;
        }
        return formattedClassLine;
    }

    private int _getLastIndexOf(String s, char c, int fromIndex) {
        int x = s.length();
        while ((x = s.lastIndexOf(c, x - 1)) != -1 && this.getLineLength(s.substring(0, x + 1)) > fromIndex) {
        }
        return x;
    }

    private boolean _hasAllowedChain(String line) throws CheckstyleException {
        String[] values;
        Map<String, String> checkstyleAttributesMap = this.getCheckstyleAttributesMap("ChainingCheck");
        String allowedClassNames = GetterUtil.getString(checkstyleAttributesMap.get("allowedClassNames"));
        String allowedVariableTypeNames = GetterUtil.getString(checkstyleAttributesMap.get("allowedVariableTypeNames"));
        for (String value : values = ArrayUtil.append(StringUtil.split(allowedClassNames), StringUtil.split(allowedVariableTypeNames))) {
            if (!line.matches(".*" + value + "\\..*")) continue;
            return true;
        }
        String allowedMethodNames = GetterUtil.getString(checkstyleAttributesMap.get("allowedMethodNames"));
        for (String value : values = StringUtil.split(allowedMethodNames)) {
            if (!line.matches(".*" + value + "\\(.*")) continue;
            return true;
        }
        return false;
    }
}

