/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaJSPDynamicIncludeCheck
extends BaseJavaTermCheck {
    private static final Pattern _jspPathPattern = Pattern.compile(".*\\s+return\\s+\"(\\S+)\";.*", 32);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String className = javaTerm.getName();
        if (!className.endsWith("DynamicInclude")) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (extendedClassNames.contains("BaseJSPDynamicInclude") && !className.endsWith("JSPDynamicInclude")) {
            this.addMessage(fileName, "Class '" + className + "' should end with 'JSPDynamicInclude'");
        }
        if (!className.endsWith("JSPDynamicInclude")) {
            return javaTerm.getContent();
        }
        String jspPath = this._getJspPath(javaClass);
        if (jspPath == null) {
            return javaTerm.getContent();
        }
        String bundleSymbolicName = this._getBundleSymbolicName(fileName);
        if (jspPath.contains(bundleSymbolicName)) {
            String message = StringBundler.concat("The JSP path should not contain '", bundleSymbolicName, "'. This is only needed when hooking into another module.");
            this.addMessage(fileName, message);
        }
        if (!jspPath.startsWith("/dynamic_include/")) {
            this.addMessage(fileName, "The JSP path should start with '/dynamic_include/'");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private BNDSettings _getBNDSettings(String fileName) throws IOException {
        String bndFileLocation = fileName;
        int pos;
        while ((pos = bndFileLocation.lastIndexOf("/")) != -1) {
            File file = new File((bndFileLocation = bndFileLocation.substring(0, pos + 1)) + "bnd.bnd");
            if (file.exists()) {
                return new BNDSettings(bndFileLocation + "bnd.bnd", FileUtil.read(file));
            }
            bndFileLocation = StringUtil.replaceLast(bndFileLocation, '/', "");
        }
        return null;
    }

    private String _getBundleSymbolicName(String fileName) throws IOException {
        BNDSettings bndSettings = this._getBNDSettings(fileName);
        if (bndSettings == null) {
            return null;
        }
        return BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
    }

    private String _getJspPath(JavaClass javaClass) {
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            JavaSignature javaSignature;
            String returnType;
            JavaMethod javaMethod;
            String name;
            if (!childJavaTerm.isJavaMethod() || !(name = (javaMethod = (JavaMethod)childJavaTerm).getName()).equals("getJspPath") || !Objects.equals(returnType = (javaSignature = javaMethod.getSignature()).getReturnType(), "String")) continue;
            String content = javaMethod.getContent();
            Matcher matcher = _jspPathPattern.matcher(content = content.replaceAll("\"\\s+\\+\\s+\"", ""));
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

