/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSStylingCheck
extends BaseFileCheck {
    private static final Pattern _multipleVarsOnSingleLinePattern = Pattern.compile("\t+var \\w+\\, ");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (content.contains("debugger.")) {
            this.addMessage(fileName, "Do not use debugger");
        }
        return this._formatMultipleVarsOnSingleLine(content);
    }

    private String _formatMultipleVarsOnSingleLine(String content) {
        Matcher matcher;
        while ((matcher = _multipleVarsOnSingleLinePattern.matcher(content)).find()) {
            String match = matcher.group();
            int pos = match.indexOf("var ");
            StringBundler sb = new StringBundler(4);
            sb.append(match.substring(0, match.length() - 2));
            sb.append(";");
            sb.append("\n");
            sb.append(match.substring(0, pos + 4));
            content = StringUtil.replace(content, match, sb.toString());
        }
        return content;
    }
}

