/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class StaticCollectionCheck
extends BaseCheck {
    private static final String _MSG_UNNEEDED_STATIC_BLOCK = "static.block.unneeded";

    public int[] getDefaultTokens() {
        return new int[]{12};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST previousSiblingAST = detailAST.getPreviousSibling();
        while (previousSiblingAST != null && previousSiblingAST.getType() == 10) {
            this._checkVariable(previousSiblingAST, detailAST);
            previousSiblingAST = previousSiblingAST.getPreviousSibling();
        }
        return;
    }

    private void _checkVariable(DetailAST variableDefAST, DetailAST staticBlockAST) {
        DetailAST modifiersAST = variableDefAST.findFirstToken(5);
        if (!modifiersAST.branchContains(39) || !modifiersAST.branchContains(64)) {
            return;
        }
        String typeName = DetailASTUtil.getTypeName(variableDefAST, false);
        if (!(typeName.equals("List") || typeName.equals("Map") || typeName.equals("Set"))) {
            return;
        }
        DetailAST identAST = variableDefAST.findFirstToken(58);
        String variableName = identAST.getText();
        int variableNameCount = this._getIdentCount(staticBlockAST, variableName);
        if (variableNameCount == 0) {
            return;
        }
        List<DetailAST> methodCallASTList = null;
        methodCallASTList = typeName.equals("Map") ? DetailASTUtil.getMethodCalls(staticBlockAST, variableName, "put") : DetailASTUtil.getMethodCalls(staticBlockAST, variableName, "add");
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST parentAST = methodCallAST.getParent();
            parentAST = parentAST.getParent();
            if ((parentAST = parentAST.getParent()).getType() == 12) continue;
            return;
        }
        if (methodCallASTList.size() == variableNameCount) {
            this.log(variableDefAST, _MSG_UNNEEDED_STATIC_BLOCK, new Object[]{typeName, variableName});
        }
    }

    private int _getIdentCount(DetailAST detailAST, String name) {
        int count = 0;
        for (DetailAST identAST : DetailASTUtil.getAllChildTokens(detailAST, true, 58)) {
            if (!name.equals(identAST.getText())) continue;
            ++count;
        }
        return count;
    }
}

