/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public abstract class MessageCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_MESSAGE = "message.incorrect";

    protected void checkMessage(String literalStringValue, int lineNo) {
        if (Validator.isNull(literalStringValue) || literalStringValue.endsWith("...")) {
            return;
        }
        String[] parts = literalStringValue.split("\\S\\. [A-Z0-9]");
        if (parts.length == 1 ^ !literalStringValue.endsWith(".")) {
            this.log(lineNo, _MSG_INCORRECT_MESSAGE, new Object[0]);
        }
    }

    protected String getLiteralStringValue(DetailAST exprAST) {
        DetailAST firstChildAST = exprAST.getFirstChild();
        if (firstChildAST.getType() == 139) {
            String s = firstChildAST.getText();
            return s.substring(1, s.length() - 1);
        }
        StringBundler sb = new StringBundler();
        if (firstChildAST.getType() == 125) {
            DetailAST childAST = firstChildAST.getFirstChild();
            do {
                if (childAST.getType() != 139) {
                    return null;
                }
                String s = childAST.getText();
                sb.append(s.substring(1, s.length() - 1));
            } while ((childAST = childAST.getNextSibling()) != null);
            return sb.toString();
        }
        if (firstChildAST.getType() != 27) {
            return null;
        }
        String methodName = DetailASTUtil.getMethodName(firstChildAST);
        if (!methodName.equals("concat")) {
            return null;
        }
        DetailAST elistAST = firstChildAST.findFirstToken(34);
        List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
        for (DetailAST curExprAST : exprASTList) {
            firstChildAST = curExprAST.getFirstChild();
            if (firstChildAST.getType() != 139) {
                return null;
            }
            String s = firstChildAST.getText();
            sb.append(s.substring(1, s.length() - 1));
        }
        return sb.toString();
    }
}

