/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class LineBreakAfterCommaCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_LINE_BREAK = "line.break.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{74};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() == 163) {
            return;
        }
        String line = this.getLine(detailAST.getLineNo() - 1);
        if (DetailASTUtil.isAtLineEnd(detailAST, line)) {
            return;
        }
        DetailAST previousSiblingAST = detailAST.getPreviousSibling();
        if (detailAST.getLineNo() != DetailASTUtil.getStartLine(previousSiblingAST)) {
            String s = StringUtil.trim(line.substring(0, detailAST.getColumnNo() + 1));
            this.log(detailAST.getLineNo(), _MSG_INCORRECT_LINE_BREAK, new Object[]{s});
        }
    }
}

