/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConfigurationAdminCheck
extends BaseFileCheck {
    private final Pattern _getConfigurationPattern = Pattern.compile("\\W_?([cC]onfigurationAdmin)\\.\\s*((get|createFactory)Configuration)\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return content;
        }
        Matcher matcher = this._getConfigurationPattern.matcher(content);
        while (matcher.find()) {
            String parameterName;
            List<String> parametersList = JavaSourceUtil.getParameterList(content.substring(matcher.start()));
            if (parametersList.size() == 2 && ((parameterName = parametersList.get(1)).equals("StringPool.QUESTION") || parameterName.equals("\"?\""))) continue;
            StringBundler sb = new StringBundler(5);
            sb.append("Incorrect call to '");
            sb.append(matcher.group(1));
            sb.append(".");
            sb.append(matcher.group(2));
            sb.append("'");
            this.addMessage(fileName, sb.toString(), "configuration_admin.markdown", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

