/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.LineBreakCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPLineBreakCheck
extends LineBreakCheck {
    private final Pattern _redundantLineBreakPattern1 = Pattern.compile("[\n\t][^/\n\t].*(\\(\n)");
    private final Pattern _redundantLineBreakPattern2 = Pattern.compile("[\n\t][^/\n\t].*[|&](\n[\t ]*)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                if (!line.startsWith("#")) {
                    this.checkLineBreaks(line, previousLine, fileName, lineNumber);
                }
                previousLine = line;
            }
        }
        content = this._fixRedundantLineBreaks(content);
        return this.fixRedundantCommaInsideArray(content);
    }

    private String _fixRedundantLineBreaks(String content) {
        Matcher matcher = this._redundantLineBreakPattern1.matcher(content);
        while (matcher.find()) {
            String codeBlock;
            if (!JSPSourceUtil.isJavaSource(content, matcher.start(1))) continue;
            int x = matcher.start(1);
            while ((x = content.indexOf(")", x + 1)) != -1 && !(codeBlock = content.substring(matcher.start(1), x + 1)).contains("{\n")) {
                if (this.getLevel(codeBlock) != 0) continue;
                String codeSingleLine = StringUtil.replace(codeBlock, new String[]{"\t", ",\n", "\n"}, new String[]{"", ", ", ""});
                return StringUtil.replaceFirst(content, codeBlock, codeSingleLine, matcher.start(1));
            }
        }
        matcher = this._redundantLineBreakPattern2.matcher(content);
        while (matcher.find()) {
            if (!JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, matcher.group(1), " ", matcher.start());
        }
        return content;
    }
}

