/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseGradleFileCheck;
import com.liferay.source.formatter.parser.GradleFile;
import java.util.TreeSet;

public class GradleBodyCheck
extends BaseGradleFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, GradleFile gradleFile, String content) {
        if (absolutePath.contains("/project-templates-")) {
            return content;
        }
        String bodyBlock = gradleFile.getBodyBlock();
        if (Validator.isNull(bodyBlock)) {
            return content;
        }
        String newBlock = "";
        TreeSet<String> newBlocks = new TreeSet<String>();
        String oldBlocks = "";
        for (String line : StringUtil.splitLines(bodyBlock)) {
            if (line.matches("(allprojects|project|subprojects|(else|for|if|while)\\s).*\\{")) {
                return content;
            }
            if (Validator.isNull(newBlock) && line.matches("\\w+\\s*\\{")) {
                newBlock = line;
                oldBlocks = oldBlocks + "\n" + line;
                continue;
            }
            if (Validator.isNotNull(newBlock) && !newBlock.endsWith("\n}")) {
                newBlock = newBlock + "\n" + line;
                oldBlocks = oldBlocks + "\n" + line;
                if (!newBlock.endsWith("\n}")) continue;
                newBlocks.add(newBlock);
                newBlock = "";
                continue;
            }
            oldBlocks = oldBlocks + "\n" + line;
            if (!Validator.isNotNull(line)) continue;
            newBlocks.clear();
            oldBlocks = "";
        }
        if (newBlocks.isEmpty()) {
            return content;
        }
        StringBundler sb = new StringBundler(2 * newBlocks.size());
        for (String s : newBlocks) {
            sb.append(s);
            sb.append("\n\n");
        }
        sb.setIndex(sb.index() - 1);
        return StringUtil.replaceLast(content, StringUtil.trim(oldBlocks), sb.toString());
    }
}

