/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.util.CheckType;

public class SourceFormatterMessage
implements Comparable<SourceFormatterMessage> {
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/documentation/";
    private final String _checkName;
    private final CheckType _checkType;
    private final String _fileName;
    private final int _lineNumber;
    private final String _markdownFileName;
    private final String _message;

    public SourceFormatterMessage(String fileName, String message) {
        this(fileName, message, -1);
    }

    public SourceFormatterMessage(String fileName, String message, CheckType checkType, String checkName, String markdownFileName, int lineNumber) {
        this._fileName = fileName;
        this._message = message;
        this._checkType = checkType;
        this._checkName = checkName;
        this._markdownFileName = markdownFileName;
        this._lineNumber = lineNumber;
    }

    public SourceFormatterMessage(String fileName, String message, int lineNumber) {
        this(fileName, message, null, lineNumber);
    }

    public SourceFormatterMessage(String fileName, String message, String markdownFileName, int lineNumber) {
        this(fileName, message, null, null, markdownFileName, lineNumber);
    }

    @Override
    public int compareTo(SourceFormatterMessage sourceFormatterMessage) {
        if (!this._fileName.equals(sourceFormatterMessage.getFileName())) {
            return this._fileName.compareTo(sourceFormatterMessage.getFileName());
        }
        if (this._lineNumber != sourceFormatterMessage.getLineNumber()) {
            return this._lineNumber - sourceFormatterMessage.getLineNumber();
        }
        return this._message.compareTo(sourceFormatterMessage.getMessage());
    }

    public String getCheckName() {
        return this._checkName;
    }

    public CheckType getCheckType() {
        return this._checkType;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getMarkdownFilePath() {
        if (this._markdownFileName == null) {
            return null;
        }
        return _DOCUMENTATION_URL + this._markdownFileName;
    }

    public String getMessage() {
        return this._message;
    }

    public String toString() {
        StringBundler sb = new StringBundler(14);
        sb.append(this._message);
        if (this._markdownFileName != null) {
            sb.append(", see ");
            sb.append(_DOCUMENTATION_URL);
            sb.append(this._markdownFileName);
        }
        sb.append(": ");
        sb.append(this._fileName);
        if (this._lineNumber > -1) {
            sb.append(" ");
            sb.append(this._lineNumber);
        }
        if (this._checkName != null) {
            sb.append(' ');
            sb.append('(');
            if (this._checkType != null) {
                sb.append(this._checkType.getValue());
                sb.append(':');
            }
            sb.append(this._checkName);
            sb.append(')');
        }
        return sb.toString();
    }
}

