/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLongLinesCheck
extends BaseFileCheck {
    private static final String _LINE_LENGTH_EXCLUDES = "line.length.excludes";
    private final Pattern _annotationPattern = Pattern.compile("\n\t*@(.+)\\(\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int lineLength;
                ++lineNumber;
                if (line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && (line.contains("final String TABLE_") || line.contains("\"create index ")) || (lineLength = this.getLineLength(line)) <= this.getMaxLineLength() || line.matches("\t*(extends|implements) [\\w.]+ \\{") || line.matches("\t*(private|protected|public) void \\w+\\(\\)( \\{)?")) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                if (this.isExcludedPath(_LINE_LENGTH_EXCLUDES, absolutePath, lineNumber) || this._isAnnotationParameter(content, trimmedLine) || trimmedLine.matches("@\\S+")) continue;
                String truncateLongLinesContent = this._getTruncateLongLinesContent(content, line, trimmedLine, lineNumber);
                if (truncateLongLinesContent != null && !truncateLongLinesContent.equals(content)) {
                    String string = truncateLongLinesContent;
                    return string;
                }
                this.addMessage(fileName, "> " + this.getMaxLineLength(), lineNumber);
            }
        }
        return content;
    }

    private int _getIfClauseLineBreakPos(String line) {
        int y;
        int x = line.lastIndexOf(" || ", this.getMaxLineLength() - 3);
        int z = Math.max(x, y = line.lastIndexOf(" && ", this.getMaxLineLength() - 3));
        if (z != -1 && !ToolsUtil.isInsideQuotes(line, z)) {
            return z + 3;
        }
        if (!(line.endsWith(" ||") || line.endsWith(" &&") || line.endsWith(") {"))) {
            return -1;
        }
        x = line.indexOf("= ");
        if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
            return x + 1;
        }
        x = line.indexOf("> ");
        if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
            return x + 1;
        }
        x = line.indexOf("< ");
        if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
            return x + 1;
        }
        x = this.getMaxLineLength() + 1;
        while ((x = line.lastIndexOf(", ", x - 1)) != -1) {
            String linePart;
            if (ToolsUtil.isInsideQuotes(line, x) || this.getLevel(linePart = line.substring(0, x)) != 0) continue;
            return x + 1;
        }
        x = 0;
        while ((x = line.indexOf(40, x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x) || !Character.isLetterOrDigit(line.charAt(x - 1)) || line.charAt(x + 1) == ')') continue;
            return x + 1;
        }
        x = line.indexOf(46);
        if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
            return x + 1;
        }
        return -1;
    }

    private String _getTruncateLongLinesContent(String content, String line, String trimmedLine, int lineNumber) {
        String firstLine;
        String secondLine;
        String firstLine2;
        int x;
        int i;
        String indent = "";
        for (i = 0; i < this.getLeadingTabCount(line); ++i) {
            indent = indent + "\t";
        }
        if (trimmedLine.matches("\\w+\\.\\w+[,);]*")) {
            x = line.indexOf(".");
            String firstLine3 = line.substring(0, x + 1);
            String secondLine2 = indent + "\t" + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine3, "\n", secondLine2, "\n"));
        }
        if ((line.endsWith("(") || line.endsWith(";")) && (x = line.indexOf(" = ")) != -1) {
            firstLine2 = line.substring(0, x + 2);
            if (firstLine2.contains("\"")) {
                return null;
            }
            secondLine = indent + "\t" + line.substring(x + 3);
            if (line.endsWith(";")) {
                return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine2, "\n", secondLine, "\n"));
            }
            if (Validator.isNotNull(this.getLine(content, lineNumber + 1))) {
                return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine2, "\n", secondLine, "\n", "\t"));
            }
        }
        if (line.endsWith(")") || line.endsWith(",") || line.endsWith("{") || line.endsWith(";")) {
            x = 0;
            while ((x = line.indexOf(", ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x) || !JavaSourceUtil.isValidJavaParameter(line.substring(0, x))) continue;
                firstLine2 = line.substring(0, x + 1);
                secondLine = indent + line.substring(x + 2);
                return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine2, "\n", secondLine, "\n"));
            }
        }
        if ((line.endsWith("{") || line.endsWith(";")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(" throws ")) != -1) {
            firstLine2 = line.substring(0, x);
            secondLine = indent + "\t" + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine2, "\n", secondLine, "\n"));
        }
        if ((line.endsWith(")") || line.endsWith("{")) && (trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && (x = line.indexOf(40)) != -1 && line.charAt(x + 1) != ')') {
            String secondLineIndent = indent + "\t";
            if (line.endsWith(")")) {
                secondLineIndent = secondLineIndent + "\t";
            }
            firstLine = line.substring(0, x + 1);
            String secondLine3 = secondLineIndent + line.substring(x + 1);
            return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine, "\n", secondLine3, "\n"));
        }
        if (line.endsWith(";")) {
            x = line.indexOf(40);
            if (x != -1) {
                char c = line.charAt(x - 1);
                if (c != ' ' && c != '\t' && line.charAt(x + 1) != ')') {
                    firstLine = line.substring(0, x + 1);
                    if (firstLine.contains("\"")) {
                        return null;
                    }
                    String secondLine4 = indent + "\t" + line.substring(x + 1);
                    return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine, "\n", secondLine4, "\n"));
                }
            } else {
                x = line.lastIndexOf(" ");
                if (x != -1 && !ToolsUtil.isInsideQuotes(line, x)) {
                    firstLine2 = line.substring(0, x);
                    secondLine = indent + "\t" + line.substring(x + 1);
                    if (this.getLineLength(secondLine) <= this.getMaxLineLength()) {
                        return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine2, "\n", secondLine, "\n"));
                    }
                }
            }
        }
        if (line.contains("\tfor (") && line.endsWith(" {") && (x = line.indexOf(" : ")) != -1) {
            String firstLine4 = line.substring(0, x + 2);
            secondLine = StringBundler.concat(indent, "\t", "\t", line.substring(x + 3));
            return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine4, "\n", secondLine, "\n\n"));
        }
        i = this._getIfClauseLineBreakPos(line);
        if (i == -1) {
            return null;
        }
        String firstLine5 = line.substring(0, i);
        secondLine = indent + line.substring(i);
        if (secondLine.endsWith(") {")) {
            return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine5, "\n", secondLine, "\n\n"));
        }
        return StringUtil.replace(content, "\n" + line + "\n", StringBundler.concat("\n", firstLine5, "\n", secondLine, "\n"));
    }

    private boolean _isAnnotationParameter(String content, String line) {
        int x = -1;
        while ((x = line.indexOf(", ", x + 1)) != -1) {
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            return false;
        }
        Matcher matcher = this._annotationPattern.matcher(content);
        block1: while (matcher.find()) {
            x = matcher.end();
            while ((x = content.indexOf(")", x + 1)) != -1) {
                String annotationParameters = content.substring(matcher.end() - 2, x + 1);
                if (this.getLevel(annotationParameters) != 0) continue;
                if (!annotationParameters.contains(line)) continue block1;
                return true;
            }
        }
        return false;
    }
}

