/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DetailASTUtil {
    public static final int ALL_TYPES = -1;

    public static List<DetailAST> getAllChildTokens(DetailAST detailAST, boolean recursive, int ... tokenTypes) {
        return DetailASTUtil._getAllChildTokens(detailAST, recursive, null, tokenTypes);
    }

    public static int getEndLine(DetailAST detailAST) {
        int endLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childAST.getLineNo() <= endLine) continue;
            endLine = childAST.getLineNo();
        }
        return endLine;
    }

    public static List<String> getImportNames(DetailAST detailAST) {
        DetailAST rootAST = detailAST;
        while (true) {
            if (rootAST.getParent() != null) {
                rootAST = rootAST.getParent();
                continue;
            }
            if (rootAST.getPreviousSibling() == null) break;
            rootAST = rootAST.getPreviousSibling();
        }
        ArrayList<String> importNamesList = new ArrayList<String>();
        DetailAST siblingAST = rootAST.getNextSibling();
        while (siblingAST.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)siblingAST);
            importNamesList.add(importIdent.getText());
            siblingAST = siblingAST.getNextSibling();
        }
        return importNamesList;
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String methodName) {
        return DetailASTUtil.getMethodCalls(detailAST, null, methodName);
    }

    public static List<DetailAST> getMethodCalls(DetailAST detailAST, String className, String methodName) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            List<DetailAST> nameASTList;
            DetailAST dotAST = methodCallAST.findFirstToken(59);
            if (dotAST == null || (nameASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 58)).size() != 2) continue;
            DetailAST classNameAST = nameASTList.get(0);
            DetailAST methodNameAST = nameASTList.get(1);
            String methodCallClassName = classNameAST.getText();
            String methodCallMethodName = methodNameAST.getText();
            if (className != null && !methodCallClassName.equals(className) || !methodCallMethodName.equals(methodName)) continue;
            list.add(methodCallAST);
        }
        return list;
    }

    public static String getMethodName(DetailAST detailAST) {
        if (detailAST.getType() != 27) {
            return null;
        }
        DetailAST dotAST = detailAST.findFirstToken(59);
        if (dotAST == null) {
            DetailAST nameAST = detailAST.findFirstToken(58);
            return nameAST.getText();
        }
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(dotAST, false, 58);
        DetailAST methodNameAST = nameASTList.get(nameASTList.size() - 1);
        return methodNameAST.getText();
    }

    public static List<DetailAST> getParameterDefs(DetailAST detailAST) {
        ArrayList<DetailAST> list = new ArrayList<DetailAST>();
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return list;
        }
        DetailAST parametersAST = detailAST.findFirstToken(20);
        return DetailASTUtil.getAllChildTokens(parametersAST, false, 21);
    }

    public static List<String> getParameterNames(DetailAST detailAST) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (DetailAST parameterDefinitionAST : DetailASTUtil.getParameterDefs(detailAST)) {
            DetailAST identAST = parameterDefinitionAST.findFirstToken(58);
            parameterNames.add(identAST.getText());
        }
        return parameterNames;
    }

    public static DetailAST getParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (!ArrayUtil.contains(tokenTypes, parentAST.getType())) continue;
            return parentAST;
        }
        return null;
    }

    public static String getSignature(DetailAST detailAST) {
        if (detailAST.getType() != 8 && detailAST.getType() != 9) {
            return "";
        }
        StringBundler sb = new StringBundler();
        sb.append('(');
        DetailAST parametersAST = detailAST.findFirstToken(20);
        List<DetailAST> parameterDefASTList = DetailASTUtil.getAllChildTokens(parametersAST, false, 21);
        if (parameterDefASTList.isEmpty()) {
            sb.append(')');
            return sb.toString();
        }
        for (DetailAST parameterDefAST : parameterDefASTList) {
            sb.append(DetailASTUtil.getTypeName(parameterDefAST, true));
            sb.append(',');
        }
        sb.setIndex(sb.index() - 1);
        sb.append(')');
        return sb.toString();
    }

    public static int getStartLine(DetailAST detailAST) {
        int startLine = detailAST.getLineNo();
        for (DetailAST childAST : DetailASTUtil.getAllChildTokens(detailAST, true, -1)) {
            if (childAST.getLineNo() >= startLine) continue;
            startLine = childAST.getLineNo();
        }
        return startLine;
    }

    public static String getTypeName(DetailAST detailAST, boolean includeTypeArguments) {
        DetailAST childAST;
        if (detailAST == null) {
            return "";
        }
        DetailAST typeAST = detailAST;
        if (detailAST.getType() != 13) {
            typeAST = detailAST.findFirstToken(13);
        }
        if ((childAST = typeAST.getFirstChild()) == null) {
            return "";
        }
        int arrayDimension = 0;
        while (childAST.getType() == 17) {
            ++arrayDimension;
            childAST = childAST.getFirstChild();
        }
        StringBundler sb = new StringBundler(1 + arrayDimension);
        FullIdent typeIdent = FullIdent.createFullIdent((DetailAST)childAST);
        sb.append(typeIdent.getText());
        for (int i = 0; i < arrayDimension; ++i) {
            sb.append("[]");
        }
        if (!includeTypeArguments) {
            return sb.toString();
        }
        DetailAST typeArgumentsAST = typeAST.findFirstToken(163);
        if (typeArgumentsAST == null) {
            return sb.toString();
        }
        sb.append('<');
        List<DetailAST> typeArgumentASTList = DetailASTUtil.getAllChildTokens(typeArgumentsAST, false, 164);
        for (DetailAST typeArgumentAST : typeArgumentASTList) {
            FullIdent typeArgumenIdent = FullIdent.createFullIdentBelow((DetailAST)typeArgumentAST);
            sb.append(typeArgumenIdent.getText());
            sb.append(',');
        }
        sb.setIndex(sb.index() - 1);
        sb.append('>');
        return sb.toString();
    }

    public static String getVariableName(DetailAST methodCallAST) {
        DetailAST dotAST = methodCallAST.findFirstToken(59);
        if (dotAST == null) {
            return null;
        }
        DetailAST nameAST = dotAST.findFirstToken(58);
        if (nameAST == null) {
            return null;
        }
        return nameAST.getText();
    }

    public static DetailAST getVariableTypeAST(DetailAST detailAST, String variableName) {
        DetailAST previousAST = detailAST;
        while (true) {
            DetailAST previousSiblingAST;
            if (previousAST.getType() == 14 || previousAST.getType() == 154 || previousAST.getType() == 15) {
                DetailAST objBlockAST = previousAST.findFirstToken(6);
                Iterator<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(objBlockAST, false, 10);
                Iterator<DetailAST> iterator = variableDefASTList.iterator();
                while (iterator.hasNext()) {
                    DetailAST variableDefAST = iterator.next();
                    if (!variableName.equals(DetailASTUtil._getVariableName(variableDefAST))) continue;
                    return variableDefAST.findFirstToken(13);
                }
            } else if (previousAST.getType() == 156 || previousAST.getType() == 35) {
                List<DetailAST> variableDefASTList = DetailASTUtil.getAllChildTokens(previousAST, false, 10);
                for (DetailAST variableDefAST : variableDefASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(variableDefAST))) continue;
                    return variableDefAST.findFirstToken(13);
                }
            } else if (previousAST.getType() == 96 || previousAST.getType() == 20) {
                List<DetailAST> parameterDefASTList = DetailASTUtil.getAllChildTokens(previousAST, false, 21);
                for (DetailAST parameterDefAST : parameterDefASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(parameterDefAST))) continue;
                    return parameterDefAST.findFirstToken(13);
                }
            } else if (previousAST.getType() == 176) {
                DetailAST recourcesAST = previousAST.findFirstToken(177);
                List<DetailAST> resourceASTList = DetailASTUtil.getAllChildTokens(recourcesAST, false, 178);
                for (DetailAST resourceAST : resourceASTList) {
                    if (!variableName.equals(DetailASTUtil._getVariableName(resourceAST))) continue;
                    return resourceAST.findFirstToken(13);
                }
            } else if (previousAST.getType() == 10 && variableName.equals(DetailASTUtil._getVariableName(previousAST))) {
                return previousAST.findFirstToken(13);
            }
            if ((previousSiblingAST = previousAST.getPreviousSibling()) != null) {
                previousAST = previousSiblingAST;
                continue;
            }
            DetailAST parentAST = previousAST.getParent();
            if (parentAST == null) break;
            previousAST = parentAST;
        }
        return null;
    }

    public static String getVariableTypeName(DetailAST detailAST, String variableName, boolean includeTypeArguments) {
        return DetailASTUtil.getTypeName(DetailASTUtil.getVariableTypeAST(detailAST, variableName), includeTypeArguments);
    }

    public static boolean hasParentWithTokenType(DetailAST detailAST, int ... tokenTypes) {
        DetailAST parentAST = DetailASTUtil.getParentWithTokenType(detailAST, tokenTypes);
        return parentAST != null;
    }

    public static boolean isArray(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST arrayDeclaratorAST = detailAST.findFirstToken(17);
        return arrayDeclaratorAST != null;
    }

    public static boolean isCollection(DetailAST detailAST) {
        if (detailAST.getType() != 13) {
            return false;
        }
        DetailAST typeArgumentsAST = detailAST.findFirstToken(163);
        if (typeArgumentsAST == null) {
            return false;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        return name.matches(".*(Collection|List|Map|Set)");
    }

    private static List<DetailAST> _getAllChildTokens(DetailAST detailAST, boolean recursive, List<DetailAST> list, int ... tokenTypes) {
        if (list == null) {
            list = new ArrayList<DetailAST>();
        }
        for (DetailAST childAST = detailAST.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
            if (ArrayUtil.contains(tokenTypes, childAST.getType()) || ArrayUtil.contains(tokenTypes, -1)) {
                list.add(childAST);
            }
            if (!recursive) continue;
            list = DetailASTUtil._getAllChildTokens(childAST, recursive, list, tokenTypes);
        }
        return list;
    }

    private static String _getVariableName(DetailAST variableDefAST) {
        DetailAST nameAST = variableDefAST.findFirstToken(58);
        return nameAST.getText();
    }
}

