/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class JavaServiceObjectCheck
extends BaseJavaTermCheck {
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".settings", "bin", "build", "classes", "dependencies", "node_modules", "sql", "src", "test", "test-classes", "test-coverage", "test-results", "tmp"};
    private final Pattern _getterCallPattern = Pattern.compile("\\W(\\w+)\\.\\s*(get)([A-Z]\\w*)\\(\\)");
    private Map<String, Element> _serviceXMLElementsMap;
    private final Pattern _setterCallPattern = Pattern.compile("(\\w+)\\.\\s*set([A-Z]\\w*)\\([^;]+;");
    private final Pattern _setterCallsPattern = Pattern.compile("(^[ \t]*\\w+\\.\\s*set[A-Z]\\w*\\([^;]+;\n)+", 40);

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        List<String> importNames = this._getImportNames(javaTerm);
        if (importNames.isEmpty()) {
            return javaTerm.getContent();
        }
        String javaTermContent = this._formatGetterMethodCalls(javaTerm.getContent(), fileContent, importNames);
        return this._formatSetterMethodCalls(javaTermContent, fileContent, importNames);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _formatGetterMethodCalls(String content, String fileContent, List<String> importNames) {
        Matcher matcher = this._getterCallPattern.matcher(content);
        while (matcher.find()) {
            String getterObjectName;
            String variableName = matcher.group(1);
            String variableTypeName = this.getVariableTypeName(content, fileContent, variableName);
            if (variableTypeName == null || !this._isBooleanColumn(variableTypeName, getterObjectName = TextFormatter.format(matcher.group(3), 8), importNames)) continue;
            return StringUtil.replaceFirst(content, "get", "is", matcher.start(2));
        }
        return content;
    }

    private String _formatSetterMethodCalls(String content, String fileContent, List<String> importNames) {
        Matcher matcher1 = this._setterCallsPattern.matcher(content);
        while (matcher1.find()) {
            String setterCallsCodeBlock = matcher1.group();
            String packageName = null;
            String previousMatch = null;
            String previousSetterObjectName = null;
            String previousVariableName = null;
            String variableTypeName = null;
            Matcher matcher2 = this._setterCallPattern.matcher(setterCallsCodeBlock);
            while (matcher2.find()) {
                String match = matcher2.group();
                String setterObjectName = TextFormatter.format(matcher2.group(2), 8);
                String variableName = matcher2.group(1);
                if (!variableName.equals(previousVariableName)) {
                    previousMatch = match;
                    previousSetterObjectName = setterObjectName;
                    previousVariableName = variableName;
                    variableTypeName = this.getVariableTypeName(content, fileContent, variableName);
                    packageName = this._getPackageName(variableTypeName, importNames);
                    continue;
                }
                Element serviceXMLElement = this._getServiceXMLElement(packageName);
                if (serviceXMLElement != null) {
                    int index1 = this._getColumnIndex(serviceXMLElement, variableTypeName, previousSetterObjectName);
                    int index2 = this._getColumnIndex(serviceXMLElement, variableTypeName, setterObjectName);
                    if (index2 != -1 && index1 > index2) {
                        int x = matcher2.start();
                        int y = content.lastIndexOf(previousMatch, x);
                        content = StringUtil.replaceFirst(content, match, previousMatch, x);
                        return StringUtil.replaceFirst(content, previousMatch, match, y);
                    }
                }
                previousMatch = match;
                previousSetterObjectName = setterObjectName;
                previousVariableName = variableName;
            }
        }
        return content;
    }

    private int _getColumnIndex(Element serviceXMLElement, String entityName, String columnName) {
        for (Element entityElement : serviceXMLElement.elements("entity")) {
            if (!entityName.equals(entityElement.attributeValue("name"))) continue;
            int i = 0;
            for (Element columnElement : entityElement.elements("column")) {
                if (columnName.equals(columnElement.attributeValue("name"))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private List<String> _getImportNames(JavaTerm javaTerm) {
        JavaClass javaClass = javaTerm.getParentJavaClass();
        JavaClass parentJavaClass;
        while ((parentJavaClass = javaClass.getParentJavaClass()) != null) {
            javaClass = parentJavaClass;
        }
        return javaClass.getImports();
    }

    private String _getPackageName(String variableTypeName, List<String> importNames) {
        for (String importName : importNames) {
            if (!importName.startsWith("com.liferay.") || !importName.endsWith(".model." + variableTypeName)) continue;
            return StringUtil.replaceLast(importName, "." + variableTypeName, "");
        }
        return "";
    }

    private Element _getServiceXMLElement(String packageName) {
        if (this._serviceXMLElementsMap != null) {
            return this._serviceXMLElementsMap.get(packageName);
        }
        this._serviceXMLElementsMap = new HashMap<String, Element>();
        try {
            this._populateServiceXMLElements("modules/apps", 6);
            this._populateServiceXMLElements("portal-impl/src/com/liferay", 4);
        }
        catch (IOException | DocumentException e) {
            return null;
        }
        return this._serviceXMLElementsMap.get(packageName);
    }

    private boolean _isBooleanColumn(String variableTypeName, String getterObjectName, List<String> importNames) {
        String packageName = this._getPackageName(variableTypeName, importNames);
        Element serviceXMLElement = this._getServiceXMLElement(packageName);
        if (serviceXMLElement == null) {
            return false;
        }
        for (Element entityElement : serviceXMLElement.elements("entity")) {
            if (!variableTypeName.equals(entityElement.attributeValue("name"))) continue;
            for (Element columnElement : entityElement.elements("column")) {
                if (!getterObjectName.equals(columnElement.attributeValue("name")) || !Objects.equals(columnElement.attributeValue("type"), "boolean")) continue;
                return true;
            }
        }
        return false;
    }

    private void _populateServiceXMLElements(String dirName, int maxDepth) throws DocumentException, IOException {
        File directory = this.getFile(dirName, 7);
        if (directory == null) {
            return;
        }
        final ArrayList serviceXMLFiles = new ArrayList();
        Files.walkFileTree(directory.toPath(), EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = dirPath.resolve("service.xml");
                if (Files.exists(path, new LinkOption[0])) {
                    serviceXMLFiles.add(path.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (File serviceXMLFile : serviceXMLFiles) {
            Document serviceXMLDocument = SourceUtil.readXML(FileUtil.read(serviceXMLFile));
            Element serviceXMLElement = serviceXMLDocument.getRootElement();
            String packagePath = serviceXMLElement.attributeValue("api-package-path");
            if (packagePath == null) {
                packagePath = serviceXMLElement.attributeValue("package-path");
            }
            if (packagePath == null) continue;
            this._serviceXMLElementsMap.put(packagePath + ".model", serviceXMLElement);
        }
    }
}

