/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPRedirectBackURLCheck
extends BaseFileCheck {
    private final Pattern _redirectBackURLPattern = Pattern.compile("(String redirect = ParamUtil\\.getString\\(request, \"redirect\".*\\);)\n(String backURL = ParamUtil\\.getString\\(request, \"backURL\", redirect\\);)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixRedirectBackURL(content);
        return content;
    }

    private String _fixRedirectBackURL(String content) {
        Matcher matcher = this._redirectBackURLPattern.matcher(content);
        String newContent = content;
        while (matcher.find()) {
            newContent = StringUtil.replaceFirst(newContent, matcher.group(), matcher.group(1) + "\n\n" + matcher.group(2), matcher.start());
        }
        return newContent;
    }
}

