/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ValidatorIsNullCheck
extends BaseCheck {
    private static final String _MSG_METHOD_INVALID_NAME = "method.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "Validator", "isNotNull");
        this._checkMethod(detailAST, "Validator", "isNull");
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallAST : methodCallASTList) {
            DetailAST typeAST;
            DetailAST elistAST = methodCallAST.findFirstToken(34);
            DetailAST expressionAST = elistAST.findFirstToken(28);
            DetailAST childAST = expressionAST.getFirstChild();
            if (childAST.getType() == 137) {
                this.log(methodCallAST.getLineNo(), _MSG_METHOD_INVALID_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
                continue;
            }
            if (childAST.getType() != 58 || (typeAST = DetailASTUtil.getVariableTypeAST(methodCallAST, childAST.getText())) == null || (childAST = typeAST.getFirstChild()).getType() != 54 && childAST.getType() != 56) continue;
            this.log(methodCallAST.getLineNo(), _MSG_METHOD_INVALID_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
        }
    }
}

