/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.File;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class SourceUtil {
    private static final String[] _ARTICLES = new String[]{"a", "an", "the"};
    private static final String[] _CONJUNCTIONS = new String[]{"and", "but", "for", "nor", "or", "yet"};
    private static final String[] _PREPOSITIONS = new String[]{"a", "abaft", "aboard", "about", "above", "absent", "across", "afore", "after", "against", "along", "alongside", "amid", "amidst", "among", "amongst", "an", "apropos", "apud", "around", "as", "aside", "astride", "at", "athwart", "atop", "barring", "before", "behind", "below", "beneath", "beside", "besides", "between", "beyond", "but", "by", "circa", "concerning", "despite", "down", "during", "except", "excluding", "failing", "for", "from", "given", "in", "including", "inside", "into", "lest", "mid", "midst", "modulo", "near", "next", "notwithstanding", "of", "off", "on", "onto", "opposite", "out", "outside", "over", "pace", "past", "per", "plus", "pro", "qua", "regarding", "sans", "since", "through", "throughout", "thru", "thruout", "till", "to", "toward", "towards", "under", "underneath", "unlike", "until", "unto", "up", "upon", "v", "versus", "via", "vice", "vs", "with", "within", "without", "worth"};

    public static String getAbsolutePath(File file) {
        return SourceUtil.getAbsolutePath(file.toPath());
    }

    public static String getAbsolutePath(Path filePath) {
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    public static String getAbsolutePath(String fileName) {
        return SourceUtil.getAbsolutePath(Paths.get(fileName, new String[0]));
    }

    public static String getIndent(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    public static int getLevel(String s) {
        return SourceUtil.getLevel(s, new String[]{"("}, new String[]{")"}, 0);
    }

    public static int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return SourceUtil.getLevel(s, new String[]{increaseLevelString}, new String[]{decreaseLevelString}, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        int level = startLevel;
        for (String increaseLevelString : increaseLevelStrings) {
            level = SourceUtil._adjustLevel(level, s, increaseLevelString, 1);
        }
        for (String decreaseLevelString : decreaseLevelStrings) {
            level = SourceUtil._adjustLevel(level, s, decreaseLevelString, -1);
        }
        return level;
    }

    public static int getLineNumber(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    public static String getTitleCase(String s, String[] exceptions) {
        Object[] words = s.split("\\s+");
        if (ArrayUtil.isEmpty(words)) {
            return s;
        }
        StringBundler sb = new StringBundler(words.length * 2);
        block0: for (int i = 0; i < words.length; ++i) {
            String lowerCaseWord;
            Object word = words[i];
            if (Validator.isNull((String)word)) continue;
            for (String exception : exceptions) {
                if (!StringUtil.equalsIgnoreCase(exception, (String)word)) continue;
                sb.append(exception);
                sb.append(' ');
                continue block0;
            }
            if (i != 0 && i != words.length && (ArrayUtil.contains(_ARTICLES, lowerCaseWord = StringUtil.toLowerCase((String)word)) || ArrayUtil.contains(_CONJUNCTIONS, lowerCaseWord) || ArrayUtil.contains(_PREPOSITIONS, lowerCaseWord))) {
                sb.append(lowerCaseWord);
                sb.append(' ');
                continue;
            }
            if (Character.isUpperCase(((String)word).charAt(0))) {
                sb.append((String)word);
            } else {
                sb.append(StringUtil.upperCaseFirstLetter((String)word));
            }
            sb.append(' ');
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static Document readXML(File file) throws Exception {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read(file);
    }

    public static Document readXML(String content) throws Exception {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }

    private static int _adjustLevel(int level, String text, String s, int diff) {
        String[] lines;
        for (String line : lines = StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("//") || line.startsWith("*")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }
}

