/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public class DockerfileSourceUtil {
    public static boolean endsWithBackSlash(String line) {
        String trimmedLine = StringUtil.trim(line);
        return Validator.isNotNull(trimmedLine) && trimmedLine.endsWith("\\");
    }

    public static String getInstruction(String line, String previousLine) {
        if (Validator.isNull(line)) {
            return "";
        }
        if (DockerfileSourceUtil.endsWithBackSlash(line) || DockerfileSourceUtil.endsWithBackSlash(previousLine)) {
            return "";
        }
        String[] words = StringUtil.split(line, ' ');
        String s = StringUtil.toUpperCase(StringUtil.trim(words[0]));
        if (!s.startsWith("#")) {
            return s;
        }
        return "#";
    }

    public static boolean isNewInstruction(String instruction, String previousInstruction, String previousLine) {
        return !Validator.isNull(previousInstruction) && !DockerfileSourceUtil.endsWithBackSlash(previousLine) && !Objects.equals(instruction, previousInstruction);
    }
}

