/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class PropertiesPortalFileCheck
extends BaseFileCheck {
    private String _portalPortalPropertiesContent;

    @Override
    public void init() throws Exception {
        this._portalPortalPropertiesContent = this._getPortalPortalPropertiesContent();
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if ((this.isPortalSource() || this.isSubrepository()) && fileName.matches(".*portal-legacy-.*\\.properties") || !this.isPortalSource() && !this.isSubrepository() && fileName.endsWith("portal.properties")) {
            this._checkPortalProperties(fileName, content);
        }
        return content;
    }

    private void _checkPortalProperties(String fileName, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            int previousPos = -1;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineNumber;
                int pos = line.indexOf(61);
                if (pos == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos + 1));
                pos = this._portalPortalPropertiesContent.indexOf("    " + property);
                if (pos == -1) continue;
                if (pos < previousPos) {
                    this.addMessage(fileName, "Follow order as in portal-impl/src/portal.properties", lineNumber);
                }
                previousPos = pos;
            }
        }
    }

    private String _getPortalPortalPropertiesContent() throws Exception {
        String portalPortalPropertiesContent = null;
        if (this.isPortalSource() || this.isSubrepository()) {
            portalPortalPropertiesContent = this.getPortalContent("portal-impl/src/portal.properties");
            if (portalPortalPropertiesContent == null) {
                return "";
            }
            return portalPortalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        portalPortalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        return portalPortalPropertiesContent;
    }
}

