/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class PropertiesLongLinesCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                this._checkMaxLineLength(line, fileName, ++lineNumber);
            }
        }
        return content;
    }

    private void _checkMaxLineLength(String line, String fileName, int lineNumber) {
        int y;
        String trimmedLine = StringUtil.trimLeading(line);
        if (!trimmedLine.startsWith("# ")) {
            return;
        }
        int lineLength = this.getLineLength(line);
        if (lineLength <= this.getMaxLineLength()) {
            return;
        }
        int x = line.indexOf("# ");
        if (x + 1 == (y = line.lastIndexOf(" ", this.getMaxLineLength()))) {
            return;
        }
        int z = line.indexOf(" ", this.getMaxLineLength() + 1);
        if (z == -1) {
            z = lineLength;
        }
        if (z - y + x + 2 <= this.getMaxLineLength()) {
            this.addMessage(fileName, "> " + this.getMaxLineLength(), lineNumber);
        }
    }
}

