/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaPackagePathCheck
extends BaseJavaTermCheck {
    private final List<String> _allowedInternalPackageDirNames = new ArrayList<String>();
    private final Pattern _internalPackagePattern = Pattern.compile("\\.(impl|internal)(\\.|\\Z)");

    public void setAllowedInternalPackageDirNames(String allowedInternalPackageDirNames) {
        Collections.addAll(this._allowedInternalPackageDirNames, StringUtil.split(allowedInternalPackageDirNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAnonymous()) {
            return javaTerm.getContent();
        }
        String packageName = javaClass.getPackageName();
        if (Validator.isNull(packageName)) {
            this.addMessage(fileName, "Missing package");
            return javaTerm.getContent();
        }
        this._checkPackageName(fileName, absolutePath, packageName, javaClass.getName(), javaClass.getImplementedClassNames());
        if (this.isModulesFile(absolutePath) && !this.isModulesApp(absolutePath, true)) {
            this._checkModulePackageName(fileName, packageName);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkModulePackageName(String fileName, String packageName) throws Exception {
        if (!packageName.startsWith("com.liferay")) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.startsWith("com.liferay")) {
            return;
        }
        if (packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|service|test)$", ""))) {
            return;
        }
        if (!packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.impl$", ".internal"))) {
            this.addMessage(fileName, "Package should follow Bundle-SymbolicName specified in " + bndSettings.getFileName(), "package.markdown");
        }
    }

    private void _checkPackageName(String fileName, String absolutePath, String packageName, String className, List<String> implementedClassNames) {
        Matcher matcher;
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packageName)) {
            this.addMessage(fileName, "The declared package '" + packageName + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packageName.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use 'impl' inside 'internal'", "package.markdown");
        }
        for (String allowedInternalPackageDirName : this._allowedInternalPackageDirNames) {
            if (!absolutePath.contains(allowedInternalPackageDirName)) continue;
            return;
        }
        if (absolutePath.contains("-api/src/") && (matcher = this._internalPackagePattern.matcher(packageName)).find()) {
            this.addMessage(fileName, "Do not use '" + matcher.group(1) + "' package in API module", "package.markdown");
        }
        if ((className.endsWith("PermissionRegistrar") || implementedClassNames.contains("ModelResourcePermissionLogic") || implementedClassNames.contains("PortletResourcePermissionLogic")) && !packageName.contains("internal.security.permission.resource") && !packageName.contains("kernel.security.permission.resource")) {
            this.addMessage(fileName, StringBundler.concat("Class '", className, "' should be in a package ", "'internal.security.permission.resource' or ", "'kernel.security.permission.resource'"));
        }
        if ((implementedClassNames.contains("ModelResourcePermissionDefinition") || implementedClassNames.contains("PortletResourcePermissionDefinition")) && !packageName.contains("internal.security.permission.resource.definition") && !packageName.contains("kernel.security.permission.resource.definition")) {
            this.addMessage(fileName, StringBundler.concat("Class '", className, "' should be in package ", "'internal.security.permission.resource.definition' or ", "'kernel.security.permission.resource.definition'"));
        }
        if (className.endsWith("OSGiCommands") && !packageName.endsWith(".osgi.commands")) {
            this.addMessage(fileName, "Class '" + className + "' should be in package ending with '.osgi.commands'");
        }
        if (className.matches(".*(?<!Display)Context") && packageName.endsWith(".display.context")) {
            this.addMessage(fileName, "The name of Class '" + className + "' should be ending with 'DisplayContext'");
        }
    }
}

