/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.StylingCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPStylingCheck
extends StylingCheck {
    private final Pattern _chainingPattern = Pattern.compile("\\WgetClass\\(\\)\\.");
    private final Pattern _emptyJavaSourceTagPattern = Pattern.compile("\n\t*<%\n+\t*%>\n");
    private final Pattern _incorrectClosingTagPattern = Pattern.compile("\n(\t*)\t((?!<\\w).)* />\n");
    private final Pattern _incorrectLineBreakPattern = Pattern.compile("[\n\t]\\} ?(catch|else|finally) ");
    private final Pattern _incorrectSingleLineJavaSourcePattern = Pattern.compile("(\t*)(<% (.*) %>)\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkChaining(fileName, content);
        this._checkLineBreak(fileName, content);
        content = this._fixEmptyJavaSourceTag(content);
        content = this._fixIncorrectClosingTag(content);
        content = this._fixIncorrectSingleLineJavaSource(content);
        content = StringUtil.replace(content, new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil.", ";;\n"}, new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil.", ";\n"});
        int pos = content.indexOf("debugger.");
        if (pos != -1) {
            this.addMessage(fileName, "Do not use debugger", this.getLineNumber(content, pos));
        }
        if ((pos = content.indexOf("console.log(")) != -1) {
            this.addMessage(fileName, "Do not use console.log", this.getLineNumber(content, pos));
        }
        if (!fileName.endsWith("test.jsp") && (pos = content.indexOf("System.out.print")) != -1) {
            this.addMessage(fileName, "Do not call 'System.out.print'", this.getLineNumber(content, pos));
        }
        return this.formatStyling(content);
    }

    @Override
    protected boolean isJavaSource(String content, int pos) {
        return JSPSourceUtil.isJavaSource(content, pos, true);
    }

    private void _checkChaining(String fileName, String content) {
        Matcher matcher = this._chainingPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "Avoid chaining on 'getClass'", "chaining.markdown", this.getLineNumber(content, matcher.start()));
        }
    }

    private void _checkLineBreak(String fileName, String content) {
        Matcher matcher = this._incorrectLineBreakPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '}'", this.getLineNumber(content, matcher.start(1)));
        }
    }

    private String _fixEmptyJavaSourceTag(String content) {
        Matcher matcher = this._emptyJavaSourceTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replace(content, matcher.group(), "");
        }
        return content;
    }

    private String _fixIncorrectClosingTag(String content) {
        Matcher matcher = this._incorrectClosingTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, " />\n", "\n" + matcher.group(1) + "/>\n", matcher.end(1));
        }
        return content;
    }

    private String _fixIncorrectSingleLineJavaSource(String content) {
        Matcher matcher = this._incorrectSingleLineJavaSourcePattern.matcher(content);
        while (matcher.find()) {
            String javaSource = matcher.group(3);
            if (javaSource.contains("<%")) continue;
            String indent = matcher.group(1);
            StringBundler sb = new StringBundler(6);
            sb.append("<%\n");
            sb.append(indent);
            sb.append(StringUtil.trim(javaSource));
            sb.append("\n");
            sb.append(indent);
            sb.append("%>");
            return StringUtil.replaceFirst(content, matcher.group(2), sb.toString(), matcher.start());
        }
        return content;
    }
}

