/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BNDBundleCheck
extends BaseFileCheck {
    private final List<String> _allowedFileNames = new ArrayList<String>();

    public void setAllowedFileNames(String allowedFileNames) {
        Collections.addAll(this._allowedFileNames, StringUtil.split(allowedFileNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!absolutePath.endsWith("/app.bnd") || !content.matches("(?s).*Liferay-Releng-Bundle:\\s*true.*")) {
            return content;
        }
        for (String allowedFileName : this._allowedFileNames) {
            if (!absolutePath.endsWith(allowedFileName)) continue;
            return content;
        }
        if (!content.matches("(?s).*Liferay-Releng-Fix-Delivery-Method:\\s*core.*")) {
            this.addMessage(fileName, StringBundler.concat("If the 'app.bnd' file contains 'Liferay-Releng-Bundle: ", "true', it must have 'Liferay-Releng-Fix-Delivery-Method: ", "core'"));
        }
        if (!content.matches("(?s).*Liferay-Releng-Marketplace:\\s*true.*")) {
            this.addMessage(fileName, "If the 'app.bnd' file contains 'Liferay-Releng-Bundle: true', it must have 'Liferay-Releng-Marketplace: true'");
        }
        if (!content.matches("(?s).*Liferay-Releng-Portal-Required:\\s*true.*")) {
            this.addMessage(fileName, StringBundler.concat("If the 'app.bnd' file contains 'Liferay-Releng-Bundle: ", "true', it must have 'Liferay-Releng-Portal-Required: ", "true'"));
        }
        if (!content.matches("(?s).*Liferay-Releng-Suite:[^\\S\\n]*\\S+.*")) {
            this.addMessage(fileName, "If the 'app.bnd' file contains 'Liferay-Releng-Bundle: true', it must define a 'Liferay-Releng-Suite'");
        }
        return content;
    }
}

