/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.GradleSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependenciesCheck
extends BaseFileCheck {
    private final Pattern _dependenciesPattern = Pattern.compile("(\n|\\A)(\t*)dependencies \\{\n");
    private final Pattern _incorrectGroupNameVersionPattern = Pattern.compile("(^[^\\s]+)\\s+\"([^:]+?):([^:]+?):([^\"]+?)\"(.*?)", 32);
    private final Pattern _incorrectWhitespacePattern = Pattern.compile(":[^ \n]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        for (String dependencies : this._getDependenciesBlocks(content)) {
            content = this._formatDependencies(absolutePath, content, dependencies);
        }
        return content;
    }

    private String _formatDependencies(String absolutePath, String content, String dependencies) {
        int y;
        String indent = SourceUtil.getIndent(dependencies);
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        Matcher matcher = this._incorrectWhitespacePattern.matcher(dependencies);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(dependencies, matcher.start())) continue;
            String newDependencies = StringUtil.insert(dependencies, " ", matcher.end() - 1);
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        if (dependencies.contains("'")) {
            String newDependencies = StringUtil.replace(dependencies, '\'', '\"');
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        TreeSet<String> uniqueDependencies = new TreeSet<String>(new GradleDependencyComparator());
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            matcher = this._incorrectGroupNameVersionPattern.matcher(dependency);
            if (matcher.find()) {
                StringBundler sb = new StringBundler(9);
                sb.append(matcher.group(1));
                sb.append(" group: \"");
                sb.append(matcher.group(2));
                sb.append("\", name: \"");
                sb.append(matcher.group(3));
                sb.append("\", version: \"");
                sb.append(matcher.group(4));
                sb.append("\"");
                sb.append(matcher.group(5));
                dependency = sb.toString();
            }
            uniqueDependencies.add(dependency);
        }
        boolean checkScope = false;
        if (this.isModulesApp(absolutePath, false) && this._hasBNDFile(absolutePath) && !GradleSourceUtil.isSpringBootExecutable(content)) {
            checkScope = true;
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            String configuration = this._getConfiguration(dependency);
            if (checkScope) {
                if (!this._isTestUtilModule(absolutePath) && configuration.equals("compile")) {
                    dependency = StringUtil.replaceFirst(dependency, "compile", "compileOnly");
                } else if (configuration.equals("compileOnly")) {
                    dependency = StringUtil.removeSubstrings(dependency, "transitive: false, ", "transitive: true,");
                }
            }
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
            }
            sb.append(indent);
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }

    private String _getConfiguration(String dependency) {
        int pos = dependency.indexOf(" ");
        if (pos != -1) {
            return dependency.substring(0, pos);
        }
        return dependency;
    }

    private List<String> _getDependenciesBlocks(String content) {
        ArrayList<String> dependenciesBlocks = new ArrayList<String>();
        Matcher matcher = this._dependenciesPattern.matcher(content);
        while (matcher.find()) {
            String dependencies;
            int level;
            int y = matcher.start();
            do {
                if ((y = content.indexOf("}", y + 1)) != -1) continue;
                return dependenciesBlocks;
            } while ((level = this.getLevel(dependencies = content.substring(matcher.start(2), y + 1), "{", "}")) != 0);
            if (dependencies.contains("}\n")) continue;
            dependenciesBlocks.add(dependencies);
        }
        return dependenciesBlocks;
    }

    private boolean _hasBNDFile(String absolutePath) {
        if (!absolutePath.endsWith("/build.gradle")) {
            return false;
        }
        int pos = absolutePath.lastIndexOf("/");
        File file = new File(absolutePath.substring(0, pos + 1) + "bnd.bnd");
        return file.exists();
    }

    private boolean _isTestUtilModule(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        return moduleName.endsWith("-test-util");
    }

    private class GradleDependencyComparator
    implements Comparator<String>,
    Serializable {
        private GradleDependencyComparator() {
        }

        @Override
        public int compare(String dependency1, String dependency2) {
            String configuration2;
            String configuration1 = GradleDependenciesCheck.this._getConfiguration(dependency1);
            if (!configuration1.equals(configuration2 = GradleDependenciesCheck.this._getConfiguration(dependency2))) {
                return dependency1.compareTo(dependency2);
            }
            String group1 = this._getPropertyValue(dependency1, "group");
            String group2 = this._getPropertyValue(dependency2, "group");
            if (group1 != null && group1.equals(group2)) {
                String name1 = this._getPropertyValue(dependency1, "name");
                String name2 = this._getPropertyValue(dependency2, "name");
                if (name1 != null && name1.equals(name2)) {
                    return 0;
                }
            }
            return dependency1.compareTo(dependency2);
        }

        private String _getPropertyValue(String dependency, String propertyName) {
            Pattern pattern = Pattern.compile(".* " + propertyName + ": \"(.+?)\"");
            Matcher matcher = pattern.matcher(dependency);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
    }
}

