/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.petra.nio.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.configuration.SourceChecksResult;
import com.liferay.source.formatter.checks.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checks.util.SourceChecksUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.Checker;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    protected boolean portalSource;
    protected SourceFormatterArgs sourceFormatterArgs;
    protected boolean subrepository;
    private List<String> _allFileNames;
    private boolean _browserStarted;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private BlockingQueue<ProgressStatusUpdate> _progressStatusQueue;
    private String _projectPathPrefix;
    private Map<String, Properties> _propertiesMap;
    private List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private SourceFormatterConfiguration _sourceFormatterConfiguration;
    private SourceFormatterExcludes _sourceFormatterExcludes;
    private Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private SourceFormatterSuppressions _sourceFormatterSuppressions;
    private final List<SourceMismatchException> _sourceMismatchExceptions = new ArrayList<SourceMismatchException>();

    @Override
    public final void format() throws Exception {
        List<String> fileNames = this.getFileNames();
        if (this.sourceFormatterArgs.isShowDebugInformation()) {
            Class<?> clazz = this.getClass();
            DebugUtil.addProcessorFileCount(clazz.getSimpleName(), fileNames.size());
        }
        if (fileNames.isEmpty()) {
            this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.CHECKS_INITIALIZED, 0));
            return;
        }
        this._sourceFormatterMessagesMap = new HashMap<String, Set<SourceFormatterMessage>>();
        this._sourceChecks = this._getSourceChecks(this._sourceFormatterConfiguration, this._containsModuleFile(fileNames));
        this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.CHECKS_INITIALIZED, fileNames.size()));
        ExecutorService executorService = Executors.newFixedThreadPool(this.sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BaseSourceProcessor.this._performTask(string);
                    return null;
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return SourceFormatterUtil.filterFileNames(fileNames, new String[0], this.getIncludes(), new SourceFormatterExcludes(), false);
        }
        return this.doGetFileNames();
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public List<SourceMismatchException> getSourceMismatchExceptions() {
        return this._sourceMismatchExceptions;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    public void setPluginsInsideModulesDirectoryNames(List<String> pluginsInsideModulesDirectoryNames) {
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
    }

    @Override
    public void setPortalSource(boolean portalSource) {
        this.portalSource = portalSource;
    }

    @Override
    public void setProgressStatusQueue(BlockingQueue<ProgressStatusUpdate> progressStatusQueue) {
        this._progressStatusQueue = progressStatusQueue;
    }

    @Override
    public void setProjectPathPrefix(String projectPathPrefix) {
        this._projectPathPrefix = projectPathPrefix;
    }

    @Override
    public void setPropertiesMap(Map<String, Properties> propertiesMap) {
        this._propertiesMap = propertiesMap;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
    }

    @Override
    public void setSourceFormatterConfiguration(SourceFormatterConfiguration sourceFormatterConfiguration) {
        this._sourceFormatterConfiguration = sourceFormatterConfiguration;
    }

    @Override
    public void setSourceFormatterExcludes(SourceFormatterExcludes sourceFormatterExcludes) {
        this._sourceFormatterExcludes = sourceFormatterExcludes;
    }

    @Override
    public void setSourceFormatterSuppressions(SourceFormatterSuppressions sourceFormatterSuppressions) {
        this._sourceFormatterSuppressions = sourceFormatterSuppressions;
    }

    @Override
    public void setSubrepository(boolean subrepository) {
        this.subrepository = subrepository;
    }

    protected void addProgressStatusUpdate(ProgressStatusUpdate progressStatusUpdate) throws Exception {
        this._progressStatusQueue.put(progressStatusUpdate);
    }

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this.sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        HashSet<String> modifiedContents = new HashSet<String>();
        TreeSet<String> modifiedMessages = new TreeSet<String>();
        String newContent = this.format(file, fileName, absolutePath, content, content, modifiedContents, modifiedMessages, 0);
        return this.processFormattedFile(file, fileName, content, newContent, modifiedMessages);
    }

    protected String format(File file, String fileName, String absolutePath, String content, String originalContent, Set<String> modifiedContents, Set<String> modifiedMessages, int count) throws Exception {
        this._sourceFormatterMessagesMap.remove(fileName);
        this._checkUTF8(file, fileName);
        String newContent = this._processSourceChecks(file, fileName, absolutePath, content, modifiedMessages);
        if (newContent == null || content.equals(newContent)) {
            return newContent;
        }
        if (!modifiedContents.add(newContent)) {
            this._sourceFormatterMessagesMap.remove(fileName);
            this.processMessage(fileName, "Infinite loop in SourceFormatter");
            return originalContent;
        }
        if (newContent.length() > content.length()) {
            if (++count > 500) {
                this._sourceFormatterMessagesMap.remove(fileName);
                this.processMessage(fileName, "Infinite loop in SourceFormatter");
                return originalContent;
            }
        } else {
            count = 0;
        }
        return this.format(file, fileName, absolutePath, newContent, originalContent, modifiedContents, modifiedMessages, count);
    }

    protected List<String> getAllFileNames() {
        return this._allFileNames;
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this.sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(excludes, includes, false);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes, boolean forceIncludeAllFiles) throws Exception {
        if (!forceIncludeAllFiles && this.sourceFormatterArgs.getRecentChangesFileNames() != null) {
            return SourceFormatterUtil.filterRecentChangesFileNames(this.sourceFormatterArgs.getBaseDirName(), this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes, this._sourceFormatterExcludes, this.sourceFormatterArgs.isIncludeSubrepositories());
        }
        return SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, includes, this._sourceFormatterExcludes, forceIncludeAllFiles);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() {
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected BlockingQueue<ProgressStatusUpdate> getProgressStatusQueue() {
        return this._progressStatusQueue;
    }

    protected Map<String, Properties> getPropertiesMap() {
        return this._propertiesMap;
    }

    protected SourceFormatterExcludes getSourceFormatterExcludes() {
        return this._sourceFormatterExcludes;
    }

    protected SourceFormatterSuppressions getSourceFormatterSuppressions() {
        return this._sourceFormatterSuppressions;
    }

    protected boolean hasGeneratedTag(String content) {
        return (content.contains("@generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    protected void postFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this.sourceFormatterArgs.isPrintErrors()) {
            SourceFormatterUtil.printError(fileName, message);
        }
    }

    protected synchronized Set<SourceFormatterMessage> processCheckstyle(Configuration configuration, CheckstyleLogger checkstyleLogger, File[] files) throws Exception {
        if (ArrayUtil.isEmpty(files)) {
            return Collections.emptySet();
        }
        Checker checker = new Checker();
        Class<?> clazz = this.getClass();
        checker.setModuleClassLoader(clazz.getClassLoader());
        SourceFormatterSuppressions sourceFormatterSuppressions = this.getSourceFormatterSuppressions();
        checker.addFilter((Filter)sourceFormatterSuppressions.getCheckstyleFilterSet());
        checker.configure(configuration);
        checker.addListener((AuditListener)checkstyleLogger);
        checker.setCheckstyleLogger(checkstyleLogger);
        checker.process(Arrays.asList(files));
        return checker.getSourceFormatterMessages();
    }

    protected File processFormattedFile(File file, String fileName, String content, String newContent, Set<String> modifiedMessages) throws Exception {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this.sourceFormatterArgs.isPrintErrors()) {
                for (String modifiedMessage : modifiedMessages) {
                    SourceFormatterUtil.printError(fileName, modifiedMessage);
                }
            }
            if (this.sourceFormatterArgs.isAutoFix()) {
                if (newContent != null) {
                    FileUtil.write(file, newContent);
                } else {
                    file.delete();
                }
            } else {
                this._sourceMismatchExceptions.add(new SourceMismatchException(fileName, content, newContent));
            }
        }
        if (this.sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                String markdownFilePath;
                SourceFormatterUtil.printError(fileName, sourceFormatterMessage.toString());
                if (this._browserStarted || !this.sourceFormatterArgs.isShowDocumentation() || !Desktop.isDesktopSupported() || !Validator.isNotNull(markdownFilePath = sourceFormatterMessage.getMarkdownFilePath())) continue;
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(markdownFilePath));
                this._browserStarted = true;
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
        return file;
    }

    protected void processMessage(String fileName, SourceFormatterMessage sourceFormatterMessage) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(sourceFormatterMessage);
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void processMessage(String fileName, String message) {
        this.processMessage(fileName, new SourceFormatterMessage(fileName, message, null, -1));
    }

    private void _checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            this.processMessage(fileName, "UTF-8");
        }
    }

    private boolean _containsModuleFile(List<String> fileNames) {
        if (this.subrepository) {
            return true;
        }
        if (!this.portalSource) {
            return false;
        }
        for (String fileName : fileNames) {
            String absolutePath;
            if (!this._isMatchPath(fileName) || !this._isModulesFile(absolutePath = SourceUtil.getAbsolutePath(fileName), true)) continue;
            return true;
        }
        return false;
    }

    private void _format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.CHECK_FILE_COMPLETED));
            return;
        }
        String absolutePath = SourceUtil.getAbsolutePath(fileName = StringUtil.replace(fileName, '\\', '/'));
        File file = new File(absolutePath);
        String content = FileUtil.read(file);
        if (this.hasGeneratedTag(content)) {
            return;
        }
        this.format(file, fileName, absolutePath, content);
        this.addProgressStatusUpdate(new ProgressStatusUpdate(ProgressStatus.CHECK_FILE_COMPLETED));
    }

    private List<SourceCheck> _getSourceChecks(SourceFormatterConfiguration sourceFormatterConfiguration, boolean includeModuleChecks) throws Exception {
        Class<?> clazz = this.getClass();
        List<SourceCheck> sourceChecks = SourceChecksUtil.getSourceChecks(sourceFormatterConfiguration, clazz.getSimpleName(), this.getPropertiesMap(), this.portalSource, this.subrepository, includeModuleChecks);
        for (SourceCheck sourceCheck : sourceChecks) {
            this._initSourceCheck(sourceCheck);
        }
        return sourceChecks;
    }

    private void _initSourceCheck(SourceCheck sourceCheck) throws Exception {
        sourceCheck.setAllFileNames(this._allFileNames);
        sourceCheck.setBaseDirName(this.sourceFormatterArgs.getBaseDirName());
        sourceCheck.setMaxLineLength(this.sourceFormatterArgs.getMaxLineLength());
        sourceCheck.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceCheck.setPortalSource(this.portalSource);
        sourceCheck.setProjectPathPrefix(this._projectPathPrefix);
        sourceCheck.setPropertiesMap(this._propertiesMap);
        sourceCheck.setSourceFormatterExcludes(this._sourceFormatterExcludes);
        sourceCheck.setSubrepository(this.subrepository);
        sourceCheck.init();
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isModulesFile(String absolutePath) {
        return this._isModulesFile(absolutePath, false);
    }

    private boolean _isModulesFile(String absolutePath, boolean includePlugins) {
        if (this.subrepository) {
            return true;
        }
        if (!this.portalSource) {
            return false;
        }
        if (includePlugins) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : this._pluginsInsideModulesDirectoryNames) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private void _performTask(String fileName) {
        try {
            if (!this.sourceFormatterArgs.isShowDebugInformation()) {
                this._format(fileName);
                return;
            }
            DebugUtil.startTask();
            this._format(fileName);
            DebugUtil.finishTask();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to format " + fileName, t);
        }
    }

    private String _processSourceChecks(File file, String fileName, String absolutePath, String content, Set<String> modifiedMessages) throws Exception {
        SourceChecksResult sourceChecksResult = SourceChecksUtil.processSourceChecks(file, fileName, absolutePath, content, modifiedMessages, this._isModulesFile(absolutePath), this._sourceChecks, this._sourceFormatterSuppressions, this.sourceFormatterArgs.isShowDebugInformation());
        for (SourceFormatterMessage sourceFormatterMessage : sourceChecksResult.getSourceFormatterMessages()) {
            this.processMessage(fileName, sourceFormatterMessage);
        }
        return sourceChecksResult.getContent();
    }
}

