/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableNameCheck
extends BaseCheck {
    private static final String[][] _ALL_CAPS_STRINGS = new String[][]{{"DDL", "Ddl"}, {"DDM", "Ddm"}, {"DL", "Dl"}, {"PK", "Pk"}};
    private static final String _MSG_RENAME_VARIABLE = "variable.rename";
    private static final Pattern _isVariableNamePattern = Pattern.compile("(_?)(is|IS_)([A-Z])(.*)");

    public int[] getDefaultTokens() {
        return new int[]{21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        this._checkCaps(detailAST, name);
        this._checkIsVariableName(detailAST, name);
    }

    private void _checkCaps(DetailAST detailAST, String name) {
        for (String[] array : _ALL_CAPS_STRINGS) {
            Pattern pattern = Pattern.compile("(.*)" + array[1] + "([A-Z].*|$)");
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            String newName = matcher.group(1) + array[0] + matcher.group(2);
            this.log(detailAST.getLineNo(), _MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private void _checkIsVariableName(DetailAST detailAST, String name) {
        if (!this._isBooleanType(detailAST.findFirstToken(13))) {
            return;
        }
        Matcher matcher = _isVariableNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String group2 = matcher.group(2);
        String newName = null;
        if (group2.equals("is")) {
            newName = StringUtil.toLowerCase(matcher.group(3)) + matcher.group(4);
            if (!Validator.isVariableName(newName)) {
                return;
            }
            newName = matcher.group(1) + newName;
        } else {
            newName = matcher.group(1) + matcher.group(3) + matcher.group(4);
        }
        if (!this._classHasVariableWithName(detailAST, newName)) {
            this.log(detailAST.getLineNo(), _MSG_RENAME_VARIABLE, new Object[]{name, newName});
        }
    }

    private boolean _classHasVariableWithName(DetailAST detailAST, String variableName) {
        ArrayList<DetailAST> definitionASTList = new ArrayList<DetailAST>();
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() == 9) {
                definitionASTList.addAll(DetailASTUtil.getAllChildTokens(parentAST, true, 21, 10));
            }
            if (parentAST.getType() != 14) continue;
            DetailAST objblockAST = parentAST.findFirstToken(6);
            definitionASTList.addAll(DetailASTUtil.getAllChildTokens(objblockAST, false, 10));
        }
        for (DetailAST definitionAST : definitionASTList) {
            DetailAST definitionNameAST = definitionAST.findFirstToken(58);
            if (!variableName.equals(definitionNameAST.getText())) continue;
            return true;
        }
        return false;
    }

    private boolean _isBooleanType(DetailAST typeAST) {
        String name;
        DetailAST childAST = typeAST.getFirstChild();
        if (childAST == null) {
            return false;
        }
        if (childAST.getType() == 50) {
            return true;
        }
        return childAST.getType() == 58 && (name = childAST.getText()).equals("Boolean");
    }
}

