/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collections;
import java.util.List;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";

    public int[] getDefaultTokens() {
        return new int[]{80};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST firstChildAST = detailAST.getFirstChild();
        if (firstChildAST == null || firstChildAST.getType() == 59) {
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        DetailAST nameAST = null;
        if (parentAST.getType() == 28) {
            nameAST = detailAST.findFirstToken(58);
        } else if (parentAST.getType() == 10) {
            nameAST = parentAST.findFirstToken(58);
        }
        if (nameAST == null) {
            return;
        }
        this._checkMissingEmptyLineAfterReferencingVariable(parentAST, nameAST.getText(), DetailASTUtil.getEndLine(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentAST, nameAST.getText(), DetailASTUtil.getEndLine(detailAST));
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String name, int endLine) {
        DetailAST previousDetailAST = detailAST;
        boolean referenced = false;
        DetailAST nextSibling = detailAST.getNextSibling();
        while (nextSibling != null && nextSibling.getType() == 45) {
            if ((nextSibling = nextSibling.getNextSibling()) == null || nextSibling.getType() != 28 && nextSibling.getType() != 10) {
                return;
            }
            boolean expressionReferencesVariable = false;
            List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSibling, true, 58);
            for (DetailAST identAST : identASTList) {
                String identName = identAST.getText();
                if (!identName.equals(name)) continue;
                expressionReferencesVariable = true;
            }
            if (!expressionReferencesVariable) {
                int startLineNextExpression;
                if (referenced && endLine + 1 == (startLineNextExpression = DetailASTUtil.getStartLine(nextSibling))) {
                    String newSub = StringUtil.trim(this._getFirstLine(nextSibling));
                    String oldSub = StringUtil.trim(this._getFirstLine(previousDetailAST));
                    String prefix = newSub.replaceAll("(\\S*\\.set).*", "$1");
                    if (!(this._containsChildToken(previousDetailAST, 80) || !prefix.isEmpty() && oldSub.startsWith(prefix))) {
                        this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{startLineNextExpression, name});
                    }
                }
                return;
            }
            endLine = DetailASTUtil.getEndLine(nextSibling);
            previousDetailAST = nextSibling;
            referenced = true;
            nextSibling = nextSibling.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLine) {
        DetailAST nextSibling = detailAST.getNextSibling();
        if (nextSibling == null || nextSibling.getType() != 45) {
            return;
        }
        if ((nextSibling = nextSibling.getNextSibling()) == null) {
            return;
        }
        int startLineNextExpression = DetailASTUtil.getStartLine(nextSibling);
        if (endLine + 1 != startLineNextExpression) {
            return;
        }
        if (this._isExpressionAssignsVariable(nextSibling, name)) {
            return;
        }
        List<DetailAST> identASTList = DetailASTUtil.getAllChildTokens(nextSibling, true, 58);
        for (DetailAST identAST : identASTList) {
            String identName = identAST.getText();
            if (!identName.equals(name)) continue;
            this.log(startLineNextExpression, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private boolean _containsChildToken(DetailAST detailAST, int tokenType) {
        List<Object> detailASTs = Collections.emptyList();
        if (detailAST != null) {
            detailASTs = DetailASTUtil.getAllChildTokens(detailAST, true, tokenType);
        }
        return !detailASTs.isEmpty();
    }

    private String _getFirstLine(DetailAST detailAST) {
        int startLine = DetailASTUtil.getStartLine(detailAST);
        if (startLine < 1) {
            return "";
        }
        return this.getLine(startLine - 1);
    }

    private boolean _isExpressionAssignsVariable(DetailAST detailAST, String name) {
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST childAST = detailAST.getFirstChild();
        if (childAST.getType() != 80) {
            return false;
        }
        DetailAST expressionNameAST = childAST.findFirstToken(58);
        if (expressionNameAST == null) {
            return false;
        }
        String expressionName = expressionNameAST.getText();
        return expressionName.equals(name);
    }
}

