/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LineBreakCheck
extends BaseFileCheck {
    private final Pattern _redundantCommaPattern = Pattern.compile(",\n\t+\\}");

    protected void checkLineBreaks(String line, String previousLine, String fileName, int lineCount) {
        int lineLeadingTabCount = this.getLeadingTabCount(line);
        int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
        if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
            this.addMessage(fileName, "There should be a line break after '('", lineCount - 1);
        }
        String trimmedLine = StringUtil.trimLeading(line);
        String strippedQuotesLine = this.stripQuotes(trimmedLine);
        int strippedQuotesLineOpenParenthesisCount = StringUtil.count(strippedQuotesLine, '(');
        if (!trimmedLine.startsWith("(") && trimmedLine.endsWith(") {") && strippedQuotesLineOpenParenthesisCount > 0 && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        if (!trimmedLine.contains(", ") && trimmedLine.endsWith(",") && !trimmedLine.startsWith("for (") && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        if (line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) {
            int y;
            int x = line.indexOf(" = ");
            if (x != -1 && this.getLevel(line, "{", "}") == 0 && ((y = line.indexOf(34)) == -1 || x < y)) {
                this.addMessage(fileName, "There should be a line break after '='", lineCount);
            }
            if ((x = line.indexOf(" -> ")) != -1 && this.getLevel(line, "{", "}") == 0 && ((y = line.indexOf(34)) == -1 || x < y)) {
                this.addMessage(fileName, "There should be a line break after '->'", lineCount);
            }
        }
    }

    protected String fixRedundantCommaInsideArray(String content) {
        Matcher matcher = this._redundantCommaPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, ",", "", matcher.start());
        }
        return content;
    }
}

