/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.IfStatementCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPIfStatementCheck
extends IfStatementCheck {
    private final Pattern _ifStatementPattern = Pattern.compile("[\t\n]((else )?if|while) .*\\) \\{\n");
    private final Pattern _testTagPattern = Pattern.compile("[\t\n]<c:(if|when) test=['\"]<%= (.+) %>['\"]>\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = this._ifStatementPattern.matcher(content);
        while (matcher.find()) {
            if (!JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            this.checkIfClauseParentheses(matcher.group(), fileName, this.getLineCount(content, matcher.start(1)));
        }
        matcher = this._testTagPattern.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            String ifClause = "if (" + matcher.group(2) + ") {";
            this.checkIfClauseParentheses(ifClause, fileName, this.getLineCount(content, matcher.start(2)));
        }
        return content;
    }
}

