/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;

public class CopyrightCheck
extends BaseFileCheck {
    private String _copyright;
    private String _copyrightFileName = "copyright.txt";

    @Override
    public void init() throws Exception {
        this._copyright = this._getCopyright();
    }

    public void setCopyrightFileName(String copyrightFileName) {
        this._copyrightFileName = copyrightFileName;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".tpl") && !fileName.endsWith(".vm")) {
            content = this._fixCopyright(fileName, absolutePath, content);
        }
        return content;
    }

    private String _fixCopyright(String fileName, String absolutePath, String content) throws Exception {
        String customCopyright = this._getCustomCopyright(absolutePath);
        if (!(content.contains(this._copyright) || customCopyright != null && content.contains(customCopyright))) {
            this.addMessage(fileName, "Missing copyright");
        } else if (!(content.startsWith(this._copyright) || content.startsWith("<%--\n" + this._copyright) || customCopyright != null && (content.startsWith(customCopyright) || content.startsWith("<%--\n" + customCopyright)))) {
            this.addMessage(fileName, "File must start with copyright");
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".tag")) {
            content = StringUtil.replace(content, "<%\n" + this._copyright + "\n%>", "<%--\n" + this._copyright + "\n--%>");
            content = StringUtil.replace(content, "<%\n" + customCopyright + "\n%>", "<%--\n" + customCopyright + "\n--%>");
        }
        return content;
    }

    private String _getCopyright() throws Exception {
        String copyright = this.getContent(this._copyrightFileName, 7);
        if (Validator.isNotNull(copyright)) {
            return copyright;
        }
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return StringUtil.read(classLoader.getResourceAsStream("dependencies/copyright.txt"));
    }

    private String _getCustomCopyright(String absolutePath) throws Exception {
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf(47, x)) != -1) {
            String copyright = FileUtil.read(new File(absolutePath.substring(0, x + 1) + "copyright.txt"));
            if (Validator.isNotNull(copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }
}

