/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDBundleInformationCheck
extends BaseFileCheck {
    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkBundleName(fileName, absolutePath, content);
            String bundleVersion = BNDSourceUtil.getDefinitionValue(content, "Bundle-Version");
            if (bundleVersion == null) {
                this.addMessage(fileName, "Missing Bundle-Version", "bnd_bundle_information.markdown");
            }
        }
        return content;
    }

    private void _checkBundleName(String fileName, String absolutePath, String content) {
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        String bundleName = BNDSourceUtil.getDefinitionValue(content, "Bundle-Name");
        if (bundleName != null) {
            String expectedBundleName;
            String strippedBundleName = StringUtil.removeChars(bundleName, '-', ' ');
            strippedBundleName = strippedBundleName.replaceAll("Implementation$", "Impl");
            if (!StringUtil.equalsIgnoreCase(strippedBundleName = strippedBundleName.replaceAll("Utilities$", "Util"), expectedBundleName = "liferay" + StringUtil.removeChars(moduleName, '-'))) {
                this.addMessage(fileName, "Incorrect Bundle-Name '" + bundleName + "'", "bnd_bundle_information.markdown");
            }
        } else {
            this.addMessage(fileName, "Missing Bundle-Name", "bnd_bundle_information.markdown");
        }
        if (moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName != null) {
            String expectedBundleSymbolicName = "com.liferay." + StringUtil.replace(moduleName, '-', '.');
            if (!bundleSymbolicName.equals(expectedBundleSymbolicName)) {
                this.addMessage(fileName, "Incorrect Bundle-SymbolicName '" + bundleSymbolicName + "'", "bnd_bundle_information.markdown");
            }
        } else {
            this.addMessage(fileName, "Missing Bundle-SymbolicName", "bnd_bundle_information.markdown");
        }
    }
}

