/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;

public class SourceFormatterMessage
implements Comparable<SourceFormatterMessage> {
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/documentation/";
    private final String _fileName;
    private final int _lineCount;
    private final String _markdownFileName;
    private final String _message;

    public SourceFormatterMessage(String fileName, String message) {
        this(fileName, message, -1);
    }

    public SourceFormatterMessage(String fileName, String message, int lineCount) {
        this(fileName, message, null, lineCount);
    }

    public SourceFormatterMessage(String fileName, String message, String markdownFileName, int lineCount) {
        this._fileName = fileName;
        this._message = message;
        this._markdownFileName = markdownFileName;
        this._lineCount = lineCount;
    }

    @Override
    public int compareTo(SourceFormatterMessage sourceFormatterMessage) {
        if (!this._fileName.equals(sourceFormatterMessage.getFileName())) {
            return this._fileName.compareTo(sourceFormatterMessage.getFileName());
        }
        if (this._lineCount != sourceFormatterMessage.getLineCount()) {
            return this._lineCount - sourceFormatterMessage.getLineCount();
        }
        return this._message.compareTo(sourceFormatterMessage.getMessage());
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public String getMarkdownFilePath() {
        if (this._markdownFileName == null) {
            return null;
        }
        return _DOCUMENTATION_URL + this._markdownFileName;
    }

    public String getMessage() {
        return this._message;
    }

    public String toString() {
        StringBundler sb = new StringBundler(8);
        sb.append(this._message);
        if (this._markdownFileName != null) {
            sb.append(", see ");
            sb.append(_DOCUMENTATION_URL);
            sb.append(this._markdownFileName);
        }
        sb.append(": ");
        sb.append(this._fileName);
        if (this._lineCount > -1) {
            sb.append(" ");
            sb.append(this._lineCount);
        }
        return sb.toString();
    }
}

