/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import aQute.bnd.osgi.Constants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSourceUtil {
    private static final String[] _APP_BND_DEFINITION_KEYS = new String[]{"Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Fix-Delivery-Method", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"};
    private static final String[] _BND_BND_DEFINITION_KEYS = new String[]{"-jsp", "-metatype-inherit", "-sass", "Bundle-ActivationPolicy", "Can-Redefine-Classes", "Can-Retransform-Classes", "Eclipse-PlatformFilter", "Implementation-Version", "JPM-Command", "Liferay-Configuration-Path", "Liferay-Export-JS-Submodules", "Liferay-JS-Config", "Liferay-Modules-Compat-Adapters", "Liferay-Releng-App-Description", "Liferay-Releng-Module-Group-Description", "Liferay-Releng-Module-Group-Title", "Liferay-Require-SchemaVersion", "Liferay-RTL-Support-Required", "Liferay-Service", "Liferay-Theme-Contributor-Type", "Liferay-Theme-Contributor-Weight", "Liferay-Top-Head-Authenticated-JS-Resources", "Liferay-Top-Head-JS-Resources", "Main-Class", "Premain-Class", "Web-ContextPath"};
    private static final String[] _COMMON_BND_DEFINITION_KEYS = new String[]{"Git-Descriptor", "Git-SHA", "Javac-Compiler", "Javac-Debug", "Javac-Deprecation", "Javac-Encoding", "Liferay-Portal-Build-Date", "Liferay-Portal-Build-Number", "Liferay-Portal-Build-Time", "Liferay-Portal-Code-Name", "Liferay-Portal-Parent-Build-Number", "Liferay-Portal-Release-Info", "Liferay-Portal-Server-Info", "Liferay-Portal-Version"};

    public static Map<String, String> getDefinitionKeysMap() {
        return BNDSourceUtil._populateDefinitionKeysMap(ArrayUtil.append(Constants.BUNDLE_SPECIFIC_HEADERS, Constants.headers, Constants.options));
    }

    public static String getDefinitionValue(String content, String key) {
        Pattern pattern = Pattern.compile("^" + key + ": (.*)(\n|\\Z)", 8);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getFileSpecificDefinitionKeysMap() {
        HashMap<String, Map<String, String>> fileSpecificDefinitionKeysMap = new HashMap<String, Map<String, String>>();
        fileSpecificDefinitionKeysMap.put("app.bnd", BNDSourceUtil._populateDefinitionKeysMap(_APP_BND_DEFINITION_KEYS));
        fileSpecificDefinitionKeysMap.put("bnd.bnd", BNDSourceUtil._populateDefinitionKeysMap(_BND_BND_DEFINITION_KEYS));
        fileSpecificDefinitionKeysMap.put("common.bnd", BNDSourceUtil._populateDefinitionKeysMap(_COMMON_BND_DEFINITION_KEYS));
        return fileSpecificDefinitionKeysMap;
    }

    public static String getModuleName(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        return absolutePath.substring(y + 1, x);
    }

    private static Map<String, String> _populateDefinitionKeysMap(String[] keys) {
        HashMap<String, String> definitionKeysMap = new HashMap<String, String>();
        for (String key : keys) {
            definitionKeysMap.put(StringUtil.toLowerCase(key), key);
        }
        return definitionKeysMap;
    }
}

