/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;

public class JavaUnsafeCastingCheck
extends BaseFileCheck {
    private static final String[] _UNSAFE_CLASS_NAMES = new String[]{"LiferayPortletRequest", "LiferayPortletResponse"};

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        for (String unsafeClassName : _UNSAFE_CLASS_NAMES) {
            int pos = -1;
            while ((pos = content.indexOf("(" + unsafeClassName + ")", pos + 1)) != -1) {
                String message = "Unsafe casting for '" + unsafeClassName + "'";
                this.addMessage(fileName, message, "unsafe_casting.markdown", this.getLineCount(content, pos));
            }
        }
        return content;
    }
}

