/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _missingEmptyLinePattern1 = Pattern.compile("[\t\n](--)?%>\n\t*(?!-->)\\S");
    private final Pattern _missingEmptyLinePattern2 = Pattern.compile("\\S(?!<\\!--)\n\t*<%(--)?\n");
    private final Pattern _missingEmptyLinePattern3 = Pattern.compile("[\t\n]<%\n\t*//");
    private final Pattern _missingEmptyLinePattern4 = Pattern.compile("[\t\n]//.*\n\t*%>\n");
    private final Pattern _redundantEmptyLinePattern1 = Pattern.compile("[\n\t]<%\n\n(\t*)[^/\n\t]");
    private final Pattern _redundantEmptyLinePattern2 = Pattern.compile("[\n\t][^/\n\t].*\n\n\t*%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this.fixEmptyLinesBetweenTags(content);
        content = this._fixMissingEmptyLines(content);
        content = this._fixRedundantEmptyLines(content);
        return content;
    }

    @Override
    protected boolean isJavaSource(String content, int pos) {
        return JSPSourceUtil.isJavaSource(content, pos);
    }

    private String _fixMissingEmptyLines(String content) {
        while (true) {
            Matcher matcher;
            if ((matcher = this._missingEmptyLinePattern1.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
                continue;
            }
            matcher = this._missingEmptyLinePattern2.matcher(content);
            if (matcher.find()) {
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
                continue;
            }
            matcher = this._missingEmptyLinePattern3.matcher(content);
            if (matcher.find()) {
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
                continue;
            }
            matcher = this._missingEmptyLinePattern4.matcher(content);
            if (!matcher.find()) break;
            content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
        }
        return content;
    }

    private String _fixRedundantEmptyLines(String content) {
        while (true) {
            Matcher matcher;
            if ((matcher = this._redundantEmptyLinePattern1.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
                continue;
            }
            matcher = this._redundantEmptyLinePattern2.matcher(content);
            if (!matcher.find()) break;
            content = StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
        }
        return content;
    }
}

