/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.InputSource;

public class CheckStyleUtil {
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();

    public static Set<SourceFormatterMessage> process(Set<File> files, List<File> suppressionsFiles, String baseDirAbsolutePath) throws Exception {
        _sourceFormatterMessages.clear();
        Checker checker = CheckStyleUtil._getChecker(suppressionsFiles, baseDirAbsolutePath);
        checker.process(ListUtil.fromCollection(files));
        return _sourceFormatterMessages;
    }

    private static Checker _getChecker(List<File> suppressionsFiles, String baseDirAbsolutePath) throws Exception {
        Checker checker = new Checker();
        ClassLoader classLoader = CheckStyleUtil.class.getClassLoader();
        checker.setModuleClassLoader(classLoader);
        for (File suppressionsFile : suppressionsFiles) {
            checker.addFilter((Filter)SuppressionsLoader.loadSuppressions((String)suppressionsFile.getAbsolutePath()));
        }
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream("checkstyle.xml")), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
        checker.configure(configuration);
        SourceFormatterLogger listener = new SourceFormatterLogger(new UnsyncByteArrayOutputStream(), true, baseDirAbsolutePath);
        checker.addListener((AuditListener)listener);
        return checker;
    }

    private static class SourceFormatterLogger
    extends DefaultLogger {
        private final String _baseDirAbsolutePath;

        public SourceFormatterLogger(OutputStream outputStream, boolean closeStreamsAfterUse, String baseDirAbsolutePath) {
            super(outputStream, closeStreamsAfterUse);
            this._baseDirAbsolutePath = baseDirAbsolutePath;
        }

        public void addError(AuditEvent auditEvent) {
            String fileName = auditEvent.getFileName();
            if (fileName.startsWith(this._baseDirAbsolutePath + "/")) {
                fileName = StringUtil.replaceFirst(fileName, this._baseDirAbsolutePath, ".");
            }
            _sourceFormatterMessages.add(new SourceFormatterMessage(fileName, auditEvent.getMessage(), auditEvent.getLine()));
            super.addError(auditEvent);
        }
    }
}

