/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;

public class SourceFormatterMessage
implements Comparable<SourceFormatterMessage> {
    private final String _fileName;
    private final int _lineCount;
    private final String _message;

    public SourceFormatterMessage(String fileName, String message) {
        this(fileName, message, -1);
    }

    public SourceFormatterMessage(String fileName, String message, int lineCount) {
        this._fileName = fileName;
        this._message = message;
        this._lineCount = lineCount;
    }

    @Override
    public int compareTo(SourceFormatterMessage sourceFormatterMessage) {
        if (!this._fileName.equals(sourceFormatterMessage.getFileName())) {
            return this._fileName.compareTo(sourceFormatterMessage.getFileName());
        }
        if (this._lineCount != -1 || sourceFormatterMessage.getLineCount() != -1) {
            return this._lineCount - sourceFormatterMessage.getLineCount();
        }
        return this._message.compareTo(sourceFormatterMessage.getMessage());
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public String getMessage() {
        return this._message;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append(this._message);
        sb.append(": ");
        sb.append(this._fileName);
        if (this._lineCount > -1) {
            sb.append(" ");
            sb.append(this._lineCount);
        }
        return sb.toString();
    }
}

