/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.css", "**/*.scss"};
    private final Pattern _commentPattern = Pattern.compile("/\\* -+(.+)-+ \\*/");
    private final Pattern _hexColorPattern = Pattern.compile("#([0-9a-f]+)[\\( ;,]");
    private final Pattern _propertiesPattern = Pattern.compile("(^(\t*)[a-z]\\S*: .+;\n)+", 8);

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = this.trimContent(content, false);
        newContent = this.sortProperties(newContent);
        newContent = this.fixComments(newContent);
        return this.fixHexColors(newContent);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.ivy/**", "**/.sass-cache/**", "**/__MACOSX/**", "**/_partial.scss", "**/_unstyled/css/**", "**/aui/**", "**/aui_deprecated.css", "**/bourbon/**", "**/converter/dependencies/**", "**/expected/**", "**/frontend-editors-web/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    protected String fixComments(String content) {
        Matcher matcher = this._commentPattern.matcher(content);
        while (matcher.find()) {
            String[] words = StringUtil.split(matcher.group(1), ' ');
            for (int i = 1; i < words.length; ++i) {
                String word;
                String previousWord = words[i - 1];
                if (previousWord.endsWith(".") || previousWord.equals("/") || (word = words[i]).length() <= 1 || !Character.isUpperCase(word.charAt(0)) || !StringUtil.isLowerCase(word.substring(1))) continue;
                content = StringUtil.replaceFirst(content, word, StringUtil.toLowerCase(word), matcher.start());
            }
        }
        return content;
    }

    protected String fixHexColors(String content) {
        Matcher matcher = this._hexColorPattern.matcher(content);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (Validator.isNumber(hexColor) || hexColor.length() < 3) continue;
            content = StringUtil.replace(content, hexColor, StringUtil.toUpperCase(hexColor));
        }
        return content;
    }

    protected String sortProperties(String content) {
        Matcher matcher = this._propertiesPattern.matcher(content);
        while (matcher.find()) {
            String parameters = StringUtil.trimTrailing(matcher.group());
            String newParameters = StringUtil.removeChar(parameters, '\t');
            List<String> parameterList = ListUtil.fromArray(StringUtil.splitLines(newParameters));
            Collections.sort(parameterList, new PropertyComparator());
            String tabs = matcher.group(2);
            StringBundler sb = new StringBundler(parameterList.size() * 3);
            for (String parameter : parameterList) {
                sb.append(tabs);
                sb.append(parameter);
                sb.append("\n");
            }
            newParameters = sb.toString();
            newParameters = newParameters.substring(0, newParameters.length() - 1);
            content = StringUtil.replaceFirst(content, parameters, newParameters, matcher.start() - 1);
        }
        return content;
    }

    private class PropertyComparator
    extends NaturalOrderStringComparator {
        private PropertyComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int pos1 = s1.indexOf(58);
            int pos2 = s2.indexOf(58);
            return super.compare(s1.substring(0, pos1), s2.substring(0, pos2));
        }
    }
}

