/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.ElementComparator;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class TLDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.tld"};
    private static final Pattern _typePattern = Pattern.compile("<type>[A-Z][a-z]*</type>");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        content = this.trimContent(content, false);
        Matcher matcher = _typePattern.matcher(content);
        while (matcher.find()) {
            int lineCount = this.getLineCount(content, matcher.start());
            this.processErrorMessage(fileName, "Use fully qualified classType: " + fileName + " " + lineCount);
        }
        Document document = this.readXML(content);
        Element rootElement = document.getRootElement();
        List tagElements = rootElement.elements("tag");
        for (Element tagElement : tagElements) {
            Element nameElement = tagElement.element("name");
            this.checkOrder(fileName, tagElement, "attribute", nameElement.getText(), new TagElementComparator());
        }
        this.checkOrder(fileName, rootElement, "tag", null, new TagElementComparator());
        return StringUtil.replace(content, "\n\n\n", "\n\n");
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/WEB-INF/tld/**", "**/test_*.tld"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    private static class TagElementComparator
    extends ElementComparator {
        private TagElementComparator() {
        }

        @Override
        protected String getElementName(Element element) {
            Element nameElement = element.element(this.getNameAttribute());
            return nameElement.getText();
        }
    }
}

